/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.api.quests.IQuest;
import com.ordwen.odailyquests.api.quests.QuestTypeRegistry;
import com.ordwen.odailyquests.quests.conditions.ConditionOperator;
import com.ordwen.odailyquests.quests.conditions.placeholder.PlaceholderCondition;
import com.ordwen.odailyquests.quests.getters.QuestItemGetter;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.rewards.Reward;
import com.ordwen.odailyquests.rewards.RewardLoader;
import com.ordwen.odailyquests.rewards.RewardType;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class QuestsLoader
extends QuestItemGetter {
    private static final String ACHIEVED_MENU_ITEM = "achieved_menu_item";
    private static final String REQUIRED_PERMISSIONS = "required_permissions";
    private static final String REQUIRED_PERMISSION = "required_permission";
    private static final String CONDITIONS = "conditions";
    private final RewardLoader rewardLoader = new RewardLoader();
    private final QuestTypeRegistry questTypeRegistry = ODailyQuests.INSTANCE.getAPI().getQuestTypeRegistry();

    private Reward createReward(ConfigurationSection questSection, String fileName, String questIndex) {
        if (!questSection.isConfigurationSection(".reward")) {
            return new Reward(RewardType.NONE, 0.0, null);
        }
        ConfigurationSection rewardSection = questSection.getConfigurationSection(".reward");
        return this.rewardLoader.getRewardFromSection(rewardSection, fileName, questIndex);
    }

    private BasicQuest createBasicQuest(ConfigurationSection questSection, String fileName, int questIndex, String fileIndex) {
        ItemStack achievedItem;
        String questName = TextFormatter.format(questSection.getString(".name"));
        List questDesc = questSection.getStringList(".description");
        for (String string : questDesc) {
            questDesc.set(questDesc.indexOf(string), TextFormatter.format(string));
        }
        String questType = questSection.getString(".quest_type");
        if (!this.questTypeRegistry.containsKey(questType)) {
            PluginLogger.configurationError(fileName, fileIndex, "quest_type", questType + " is not a valid quest type.");
            return null;
        }
        String requiredAmount = questSection.getString(".required_amount", "1");
        List requiredWorlds = questSection.getStringList(".required_worlds");
        List requiredRegions = questSection.getStringList(".required_regions");
        boolean protectionBypass = questSection.getBoolean(".protection_bypass");
        List<Object> requiredPermissions = questSection.isString(REQUIRED_PERMISSIONS) ? List.of(questSection.getString(REQUIRED_PERMISSIONS)) : (questSection.isList(REQUIRED_PERMISSIONS) ? questSection.getStringList(REQUIRED_PERMISSIONS) : (questSection.isString(REQUIRED_PERMISSION) ? List.of(questSection.getString(REQUIRED_PERMISSION)) : Collections.emptyList()));
        List<PlaceholderCondition> placeholderConditions = this.parsePlaceholderConditions(questSection, fileName, fileIndex);
        if (placeholderConditions == null) {
            return null;
        }
        String presumedItem = questSection.getString(".menu_item");
        if (presumedItem == null) {
            PluginLogger.configurationError(fileName, fileIndex, "menu_item", "The menu item is not defined.");
            return null;
        }
        ItemStack menuItem = this.getItemStackFromMaterial(presumedItem, fileName, fileIndex, "menu_item");
        if (menuItem == null) {
            return null;
        }
        int menuItemAmount = questSection.getInt(".menu_item_amount", 1);
        if (menuItemAmount < 0 || menuItemAmount > 64) {
            PluginLogger.configurationError(fileName, fileIndex, "menu_item_amount", "The menu item amount must be between 0 and 64.");
            return null;
        }
        if (questSection.isString(ACHIEVED_MENU_ITEM)) {
            String presumedAchievedItem = questSection.getString(ACHIEVED_MENU_ITEM);
            achievedItem = this.getItemStackFromMaterial(presumedAchievedItem, fileName, fileIndex, ACHIEVED_MENU_ITEM);
            if (achievedItem == null) {
                return null;
            }
        } else {
            achievedItem = menuItem;
        }
        Reward reward = this.createReward(questSection, fileName, fileIndex);
        return new BasicQuest(questIndex, fileIndex, questName, fileName, questDesc, questType, menuItem, menuItemAmount, achievedItem, requiredAmount, reward, requiredWorlds, requiredRegions, protectionBypass, requiredPermissions, placeholderConditions);
    }

    public void loadQuests(FileConfiguration file, List<AbstractQuest> quests, String fileName) {
        ConfigurationSection allQuestsSection = file.getConfigurationSection("quests");
        if (allQuestsSection == null) {
            PluginLogger.error("Impossible to load " + fileName + ": there is no quests in " + fileName + " file!");
            return;
        }
        int questIndex = 0;
        for (String fileQuest : allQuestsSection.getKeys(false)) {
            String questType;
            BasicQuest base;
            ConfigurationSection questSection = allQuestsSection.getConfigurationSection(fileQuest);
            if (questSection == null || (base = this.createBasicQuest(questSection, fileName, questIndex, fileQuest)) == null || !this.registerQuest(quests, fileName, questType = base.getQuestType(), base, questSection, fileQuest)) continue;
            ++questIndex;
        }
        PluginLogger.info(quests.size() + " quests loaded from " + fileName + " file.");
    }

    private boolean registerQuest(List<AbstractQuest> quests, String fileName, String questType, BasicQuest base, ConfigurationSection questSection, String questIndex) {
        Class questClass = (Class)this.questTypeRegistry.get(questType);
        IQuest questInstance = null;
        try {
            questInstance = (AbstractQuest)questClass.getDeclaredConstructor(BasicQuest.class).newInstance(base);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            PluginLogger.error("Error while creating a new instance of " + questType + " quest.");
            PluginLogger.error(e.getMessage());
        }
        if (questInstance != null && questInstance.loadParameters(questSection, fileName, questIndex)) {
            quests.add((AbstractQuest)questInstance);
            return true;
        }
        return false;
    }

    private List<PlaceholderCondition> parsePlaceholderConditions(ConfigurationSection questSection, String fileName, String questIndex) {
        if (!questSection.isConfigurationSection(CONDITIONS)) {
            return Collections.emptyList();
        }
        ConfigurationSection conditionsSection = questSection.getConfigurationSection(CONDITIONS);
        if (conditionsSection == null) {
            return Collections.emptyList();
        }
        ArrayList<PlaceholderCondition> conditions = new ArrayList<PlaceholderCondition>();
        for (String key : conditionsSection.getKeys(false)) {
            ConditionOperator conditionOperator;
            ConfigurationSection conditionSection = conditionsSection.getConfigurationSection(key);
            if (conditionSection == null) {
                PluginLogger.configurationError(fileName, questIndex, "conditions." + key, "The condition section is invalid.");
                return null;
            }
            String placeholder = conditionSection.getString("placeholder");
            if (placeholder == null || placeholder.isEmpty()) {
                PluginLogger.configurationError(fileName, questIndex, "conditions." + key + ".placeholder", "The placeholder value is missing.");
                return null;
            }
            String operatorRaw = conditionSection.getString("operator");
            if (operatorRaw == null || operatorRaw.isEmpty()) {
                PluginLogger.configurationError(fileName, questIndex, "conditions." + key + ".operator", "The condition operator is missing.");
                return null;
            }
            try {
                conditionOperator = ConditionOperator.valueOf(operatorRaw.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                PluginLogger.configurationError(fileName, questIndex, "conditions." + key + ".operator", operatorRaw + " is not a valid operator.");
                return null;
            }
            Object expectedObject = conditionSection.get("expected");
            if (expectedObject == null) {
                PluginLogger.configurationError(fileName, questIndex, "conditions." + key + ".expected", "The expected value is missing.");
                return null;
            }
            String expectedValue = String.valueOf(expectedObject);
            String errorMessage = conditionSection.getString("error_message");
            conditions.add(new PlaceholderCondition(placeholder, conditionOperator, expectedValue, errorMessage));
        }
        return conditions;
    }
}

