/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression;

import com.jeff_media.customblockdata.CustomBlockData;
import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.api.events.QuestCompletedEvent;
import com.ordwen.odailyquests.api.events.QuestProgressEvent;
import com.ordwen.odailyquests.configuration.essentials.Antiglitch;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.essentials.Synchronization;
import com.ordwen.odailyquests.configuration.functionalities.CompleteOnlyOnClick;
import com.ordwen.odailyquests.configuration.functionalities.DisabledWorlds;
import com.ordwen.odailyquests.configuration.functionalities.progression.ProgressionMessage;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.externs.hooks.Protection;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.QuestLoaderUtils;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.item.FarmingQuest;
import com.ordwen.odailyquests.tools.DisplayName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerProgressor {
    protected static final Set<Material> VERTICAL_PLANTS_UP = Set.of(Material.SUGAR_CANE, Material.CACTUS, Material.BAMBOO, Material.KELP_PLANT, Material.TWISTING_VINES_PLANT);
    protected static final Set<Material> VERTICAL_PLANTS_DOWN = Set.of(Material.WEEPING_VINES_PLANT, Material.CAVE_VINES_PLANT);

    protected static boolean isVerticalPlant(Material m) {
        return VERTICAL_PLANTS_UP.contains(m) || VERTICAL_PLANTS_DOWN.contains(m);
    }

    public void setPlayerQuestProgression(Event event, Player player, int amount, String questType) {
        if (QuestsManager.getActiveQuests().containsKey(player.getName())) {
            Debugger.write("Active quests contain " + player.getName() + ".");
            this.checkForProgress(event, player, amount, questType);
        }
    }

    private void checkForProgress(Event event, Player player, int amount, String questType) {
        Map<AbstractQuest, Progression> playerQuests = ODailyQuestsAPI.getPlayerQuests(player.getName()).getQuests();
        for (Map.Entry<AbstractQuest, Progression> entry : playerQuests.entrySet()) {
            Progression progression;
            AbstractQuest quest = entry.getKey();
            if (!quest.getQuestType().equals(questType) || (progression = entry.getValue()).isAchieved() || !quest.canProgress(event, progression)) continue;
            this.actionQuest(player, progression, quest, amount);
            if (Synchronization.isSynchronised()) continue;
            break;
        }
    }

    public void actionQuest(Player player, Progression progression, AbstractQuest quest, int amount) {
        Debugger.write("QuestProgressUtils: actionQuest summoned by " + player.getName() + " for " + quest.getQuestName() + " with amount " + amount + ".");
        QuestProgressEvent event = new QuestProgressEvent(player, progression, quest, amount);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            Debugger.write("QuestProgressUtils: QuestProgressEvent is not cancelled.");
            this.runProgress(player, progression, quest, amount);
        }
    }

    private void runProgress(Player player, Progression progression, AbstractQuest quest, int amount) {
        if (QuestLoaderUtils.isTimeToRenew(player, QuestsManager.getActiveQuests())) {
            return;
        }
        if (!this.isAllowedToProgress(player, quest)) {
            return;
        }
        String questName = quest.getQuestName().replace("%displayName%", DisplayName.getDisplayName(quest, progression.getSelectedRequiredIndex()));
        int current = progression.getAdvancement();
        int required = progression.getRequiredAmount();
        int remaining = required - current;
        int toAdd = Math.min(amount, remaining);
        Debugger.write("QuestProgressUtils: increasing progression for " + questName + " by " + toAdd + ".");
        for (int i = 0; i < toAdd; ++i) {
            progression.increaseAdvancement();
        }
        if (progression.getAdvancement() >= required) {
            Debugger.write("QuestProgressUtils: progression " + progression.getAdvancement() + " is greater than or equal to amount required " + progression.getRequiredAmount() + ".");
            if (CompleteOnlyOnClick.isEnabled()) {
                return;
            }
            ODailyQuests.morePaperLib.scheduling().globalRegionalScheduler().runDelayed(() -> {
                Debugger.write("QuestProgressUtils: QuestCompletedEvent is called.");
                QuestCompletedEvent completedEvent = new QuestCompletedEvent(player, progression, quest);
                Bukkit.getPluginManager().callEvent((Event)completedEvent);
            }, 1L);
            return;
        }
        ProgressionMessage.sendProgressionMessage(player, questName, progression.getAdvancement(), progression.getRequiredAmount());
    }

    public boolean isAllowedToProgress(Player player, AbstractQuest quest) {
        if (!player.hasPermission("odailyquests.progress")) {
            Debugger.write("PlayerProgressor: isAllowedToProgress cancelled due to missing permission.");
            return false;
        }
        if (DisabledWorlds.isWorldDisabled(player.getWorld().getName())) {
            Debugger.write("PlayerProgressor: isAllowedToProgress cancelled due to disabled world.");
            return false;
        }
        if (!quest.getRequiredWorlds().isEmpty() && !quest.getRequiredWorlds().contains(player.getWorld().getName())) {
            String msg = QuestsMessages.NOT_REQUIRED_WORLD.getMessage(player);
            if (msg != null) {
                player.sendMessage(msg);
            }
            return false;
        }
        if (!quest.getRequiredRegions().isEmpty() && !Protection.checkRegion(player, quest.getRequiredRegions())) {
            String msg = QuestsMessages.NOT_REQUIRED_REGION.getMessage(player);
            if (msg != null) {
                player.sendMessage(msg);
            }
            return false;
        }
        return true;
    }

    public int fits(ItemStack stack, ItemStack[] contents) {
        int result = 0;
        for (ItemStack is : contents) {
            if (is == null) {
                result += stack.getMaxStackSize();
                continue;
            }
            if (!is.isSimilar(stack)) continue;
            result += Math.max(stack.getMaxStackSize() - is.getAmount(), 0);
        }
        return result;
    }

    public boolean movingItem(ItemStack result, int recipeAmount, Player player, ClickType click) {
        ItemStack cursorItem = player.getItemOnCursor();
        if (cursorItem.getType() != Material.AIR) {
            if (cursorItem.getType() == result.getType()) {
                if (cursorItem.getAmount() + recipeAmount > cursorItem.getMaxStackSize()) {
                    return click == ClickType.LEFT || click == ClickType.RIGHT;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean isPlayerPlacedBlock(Block block, Material material) {
        if (material.isBlock() && Antiglitch.isStorePlacedBlocks()) {
            CustomBlockData pdc = new CustomBlockData(block, (Plugin)ODailyQuests.INSTANCE);
            if (!pdc.has(Antiglitch.PLACED_KEY, PersistentDataType.STRING)) {
                Debugger.write("PlayerProgressor: isPlayerPlacedBlock no PLACED_KEY, not a placed block.");
                return false;
            }
            String previousType = (String)pdc.get(Antiglitch.PLACED_KEY, PersistentDataType.STRING);
            if (previousType != null && previousType.equals(material.name())) {
                Debugger.write("PlayerProgressor: isPlayerPlacedBlock cancelled, block was placed (type=" + previousType + ").");
                return true;
            }
            Debugger.write("PlayerProgressor: isPlayerPlacedBlock type changed (" + previousType + " -> " + material.name() + "), allow.");
            return false;
        }
        Debugger.write("PlayerProgressor: isPlayerPlacedBlock not storing placed blocks, or material is not a block.");
        return false;
    }

    protected void handleDrops(Event event, Player player, List<Item> drops) {
        Debugger.write("PlayerProgressor: handleDrops summoned.");
        for (Item item : drops) {
            ItemStack droppedItem = item.getItemStack();
            Material droppedMaterial = droppedItem.getType();
            Debugger.write("PlayerProgressor: handling drop: " + String.valueOf(droppedMaterial) + ".");
            FarmingQuest.setCurrent(new ItemStack(droppedMaterial));
            this.setPlayerQuestProgression(event, player, droppedItem.getAmount(), "FARMING");
        }
    }

    protected void storeBrokenBlockMetadata(Collection<? extends ItemStack> drops, Player player) {
        for (ItemStack itemStack : drops) {
            Debugger.write("PlayerProgressor: onBlockDropItemEvent storing broken block: " + String.valueOf(itemStack.getType()));
            ItemMeta dropMeta = itemStack.getItemMeta();
            if (dropMeta == null) continue;
            PersistentDataContainer pdc = dropMeta.getPersistentDataContainer();
            pdc.set(Antiglitch.BROKEN_KEY, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
            itemStack.setItemMeta(dropMeta);
        }
    }
}

