/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.essentials.Logs;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.configuration.essentials.RenewInterval;
import com.ordwen.odailyquests.configuration.essentials.RenewTime;
import com.ordwen.odailyquests.configuration.essentials.TimestampMode;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.categories.Category;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class QuestLoaderUtils {
    private QuestLoaderUtils() {
    }

    public static boolean checkTimestamp(long timestamp) {
        int mode = TimestampMode.getTimestampMode();
        Duration renewInterval = RenewInterval.getRenewInterval();
        switch (mode) {
            case 1: {
                LocalTime renewTime = RenewTime.getRenewTime();
                ZoneId zone = RenewTime.getZoneId();
                ZonedDateTime lastRenew = Instant.ofEpochMilli(timestamp).atZone(zone);
                ZonedDateTime now = ZonedDateTime.now(zone);
                ZonedDateTime todayRenew = ZonedDateTime.of(now.toLocalDate(), renewTime, zone);
                ZonedDateTime lastEffectiveRenew = now.isBefore(todayRenew) ? todayRenew.minusDays(1L) : todayRenew;
                return lastRenew.isBefore(lastEffectiveRenew);
            }
            case 2: {
                if (renewInterval != null) {
                    return System.currentTimeMillis() - timestamp >= renewInterval.toMillis();
                }
                PluginLogger.error(String.valueOf(ChatColor.RED) + "Impossible to check player quests timestamp. Renew interval is incorrect.");
                break;
            }
            default: {
                PluginLogger.error(String.valueOf(ChatColor.RED) + "Impossible to load player quests timestamp. The selected mode is incorrect.");
            }
        }
        return false;
    }

    public static void loadNewPlayerQuests(String playerName, Map<String, PlayerQuests> activeQuests, Map<String, Integer> totalAchievedQuestsByCategory, int totalAchievedQuests) {
        Debugger.write("Entering loadNewPlayerQuests method for player " + playerName + ".");
        activeQuests.remove(playerName);
        Player player = Bukkit.getPlayer((String)playerName);
        Debugger.write("Attempting to renew quests for player " + playerName + ".");
        if (player == null) {
            Debugger.write("Player " + playerName + " is null. Impossible to renew quests.");
            PluginLogger.warn("It seems that " + playerName + " disconnected before the end of the quest renewal.");
            return;
        }
        Map<AbstractQuest, Progression> quests = QuestsManager.selectRandomQuests(player);
        PlayerQuests playerQuests = TimestampMode.getTimestampMode() == 1 ? new PlayerQuests(Calendar.getInstance().getTimeInMillis(), quests) : new PlayerQuests(System.currentTimeMillis(), quests);
        playerQuests.setTotalAchievedQuests(totalAchievedQuests);
        playerQuests.setTotalAchievedQuestsByCategory(totalAchievedQuestsByCategory);
        String msg = QuestsMessages.QUESTS_RENEWED.getMessage(player);
        if (msg != null && player.hasPermission(QuestsPermissions.QUESTS_PROGRESS.get())) {
            player.sendMessage(msg);
        }
        activeQuests.put(playerName, playerQuests);
        if (Logs.isEnabled()) {
            PluginLogger.info(playerName + "'s quests have been renewed.");
        }
        Debugger.write("Quests of player " + playerName + " have been renewed.");
    }

    public static boolean isTimeToRenew(Player player, Map<String, PlayerQuests> activeQuests) {
        if (TimestampMode.getTimestampMode() == 1) {
            return false;
        }
        PlayerQuests playerQuests = activeQuests.get(player.getName());
        if (QuestLoaderUtils.checkTimestamp(playerQuests.getTimestamp())) {
            QuestLoaderUtils.loadNewPlayerQuests(player.getName(), activeQuests, playerQuests.getTotalAchievedQuestsByCategory(), playerQuests.getTotalAchievedQuests());
            return true;
        }
        return false;
    }

    public static AbstractQuest findQuest(String playerName, int questIndex, int id) {
        AbstractQuest quest = null;
        Map<String, Category> categoryMap = CategoriesLoader.getAllCategories();
        int totalQuestsCount = 0;
        for (Map.Entry<String, Category> entry : categoryMap.entrySet()) {
            String categoryName = entry.getKey();
            Category category = entry.getValue();
            int categoryQuestsAmount = QuestsPerCategory.getAmountForCategory(categoryName);
            if (id <= totalQuestsCount + categoryQuestsAmount) {
                quest = QuestLoaderUtils.getQuestAtIndex(category, questIndex, playerName);
                break;
            }
            totalQuestsCount += categoryQuestsAmount;
        }
        if (quest == null) {
            PluginLogger.warn("Quest ID " + id + " was not found. Player quests will be reset.");
            PluginLogger.warn("This can happen after a server reload or if the quest was deleted from the file.");
        }
        return quest;
    }

    public static AbstractQuest getQuestAtIndex(Category category, int index, String playerName) {
        AbstractQuest quest = null;
        try {
            quest = (AbstractQuest)category.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            if (!category.isEmpty()) {
                QuestLoaderUtils.playerQuestMissing(playerName);
            }
            QuestLoaderUtils.noQuestsAvailable();
        }
        return quest;
    }

    private static void playerQuestMissing(String playerName) {
        PluginLogger.warn("A quest of the player " + playerName + " could not be loaded.");
        PluginLogger.warn("This happens when a previously loaded quest has been deleted from the file.");
        PluginLogger.warn("To avoid this problem, you should reset player progressions when you delete quests.");
        PluginLogger.warn("New quests will be drawn for the player.");
    }

    private static void noQuestsAvailable() {
        PluginLogger.error("There is no quest at all available!");
        PluginLogger.error("It can happen if IA/Oraxen/Nexo integration is enabled without the corresponding plugin.");
        PluginLogger.error("Please check your configuration. If the problem persists, contact the developer.");
    }
}

