/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.clickable;

import com.ordwen.odailyquests.api.events.QuestCompletedEvent;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestContext;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public abstract class QuestCommand<Q extends AbstractQuest> {
    protected final QuestContext context;
    protected final Progression progression;
    protected final Q quest;

    protected QuestCommand(QuestContext context, Progression progression, Q quest) {
        this.context = context;
        this.progression = progression;
        this.quest = quest;
    }

    public abstract void execute();

    protected void sendMessage(QuestsMessages message) {
        String msg = message.getMessage(this.context.getPlayer());
        if (msg != null) {
            this.context.getPlayer().sendMessage(msg);
        }
    }

    protected void completeQuest() {
        Bukkit.getPluginManager().callEvent((Event)new QuestCompletedEvent(this.context.getPlayer(), this.progression, (AbstractQuest)this.quest));
        this.context.getPlayer().closeInventory();
    }
}

