/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.clickable;

import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestContext {
    @NotNull
    private final Player player;
    @Nullable
    private final ItemStack clickedItem;
    @Nullable
    private final Villager villager;
    @Nullable
    private final MerchantRecipe selectedRecipe;
    private final int quantity;

    private QuestContext(Builder builder) {
        this.player = builder.player;
        this.clickedItem = builder.clickedItem;
        this.villager = builder.villager;
        this.selectedRecipe = builder.selectedRecipe;
        this.quantity = builder.quantity;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public ItemStack getClickedItem() {
        return this.clickedItem;
    }

    @Nullable
    public Villager getVillager() {
        return this.villager;
    }

    @Nullable
    public MerchantRecipe getSelectedRecipe() {
        return this.selectedRecipe;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public static class Builder {
        @NotNull
        private final Player player;
        @Nullable
        private ItemStack clickedItem;
        @Nullable
        private Villager villager;
        @Nullable
        private MerchantRecipe selectedRecipe;
        private int quantity = 1;

        public Builder(@NotNull Player player) {
            this.player = player;
        }

        public Builder clickedItem(@Nullable ItemStack clickedItem) {
            this.clickedItem = clickedItem;
            return this;
        }

        public Builder villagerTrade(@Nullable Villager villager, @Nullable MerchantRecipe selectedRecipe, int quantity) {
            this.villager = villager;
            this.selectedRecipe = selectedRecipe;
            this.quantity = quantity;
            return this;
        }

        public QuestContext build() {
            return new QuestContext(this);
        }
    }
}

