/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.listeners;

import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.api.events.QuestCompletedEvent;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.rewards.RewardManager;
import com.ordwen.odailyquests.tools.DisplayName;
import com.ordwen.odailyquests.tools.TextFormatter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class QuestCompletedListener
implements Listener {
    @EventHandler
    public void onQuestCompletedEvent(QuestCompletedEvent event) {
        Player player = event.getPlayer();
        Progression progression = event.getProgression();
        AbstractQuest quest = event.getAbstractQuest();
        Debugger.write("QuestCompletedListener: QuestCompletedEvent summoned by " + player.getName() + " for " + quest.getQuestName() + ".");
        if (progression.isAchieved()) {
            return;
        }
        progression.setAchieved();
        String formattedQuestName = TextFormatter.format(player, quest.getQuestName()).replace("%required%", String.valueOf(progression.getRequiredAmount())).replace("%displayName%", DisplayName.getDisplayName(quest, progression.getSelectedRequiredIndex()));
        RewardManager.sendQuestRewardItems(formattedQuestName, player, quest.getReward(), progression);
        ODailyQuestsAPI.getPlayerQuests(player.getName()).increaseCategoryAchievedQuests(quest.getCategoryName(), player);
    }
}

