/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.storage;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Database;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.storage.sql.SQLManager;
import com.ordwen.odailyquests.quests.player.progression.storage.sql.mysql.MySQLManager;
import com.ordwen.odailyquests.quests.player.progression.storage.sql.sqlite.SQLiteManager;
import com.ordwen.odailyquests.quests.player.progression.storage.yaml.YamlManager;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.Map;

public class DatabaseManager {
    private final ODailyQuests plugin;
    private SQLManager sqlManager;
    private YamlManager yamlManager;

    public DatabaseManager(ODailyQuests plugin) {
        this.plugin = plugin;
    }

    public void load() {
        switch (Database.getMode()) {
            case MYSQL: {
                this.sqlManager = new MySQLManager();
                this.yamlManager = null;
                break;
            }
            case SQLITE: {
                this.sqlManager = new SQLiteManager();
                this.yamlManager = null;
                break;
            }
            case YAML: {
                this.yamlManager = new YamlManager(this.plugin.getFilesManager().getProgressionFile());
                this.sqlManager = null;
            }
        }
    }

    public void close() {
        if (this.sqlManager != null) {
            this.sqlManager.close();
        }
    }

    public void loadQuestsForPlayer(String playerName) {
        Map<String, PlayerQuests> activeQuests = QuestsManager.getActiveQuests();
        switch (Database.getMode()) {
            case YAML: {
                this.yamlManager.getLoadProgressionYAML().loadPlayerQuests(playerName, activeQuests);
                break;
            }
            case MYSQL: 
            case SQLITE: {
                this.sqlManager.getLoadProgressionSQL().loadProgression(playerName, activeQuests);
                break;
            }
            default: {
                PluginLogger.error("Impossible to load player quests : the selected storage mode is incorrect !");
            }
        }
    }

    public void saveProgressionForPlayer(String playerName, String playerUuid, PlayerQuests playerQuests) {
        switch (Database.getMode()) {
            case YAML: {
                this.yamlManager.getSaveProgressionYAML().saveProgression(playerName, playerUuid, playerQuests, this.plugin.isServerStopping());
                break;
            }
            case MYSQL: 
            case SQLITE: {
                this.sqlManager.getSaveProgressionSQL().saveProgression(playerName, playerUuid, playerQuests, this.plugin.isServerStopping());
                break;
            }
            default: {
                PluginLogger.error("Impossible to save player quests : the selected storage mode is incorrect !");
            }
        }
    }

    public SQLManager getSqlManager() {
        return this.sqlManager;
    }

    public YamlManager getYamlManager() {
        return this.yamlManager;
    }
}

