/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.storage.sql;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.essentials.Logs;
import com.ordwen.odailyquests.configuration.essentials.PlayerDataLoadDelay;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.enums.SQLQuery;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.ProgressionLoader;
import com.ordwen.odailyquests.quests.player.progression.QuestLoaderUtils;
import com.ordwen.odailyquests.quests.player.progression.storage.sql.SQLManager;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LoadProgressionSQL
extends ProgressionLoader {
    private final SQLManager sqlManager;

    public LoadProgressionSQL(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public void loadProgression(String playerName, Map<String, PlayerQuests> activeQuests) {
        Debugger.write("Entering loadProgression (SQL) method for player " + playerName + ".");
        LinkedHashMap quests = new LinkedHashMap();
        ODailyQuests.morePaperLib.scheduling().asyncScheduler().runDelayed(() -> {
            Debugger.write("Running async task to load progression of " + playerName + " from SQL database.");
            Player player = Bukkit.getPlayer((String)playerName);
            if (player == null) {
                this.handlePlayerDisconnected(playerName);
                return;
            }
            String playerUuid = player.getUniqueId().toString();
            boolean hasStoredData = false;
            long timestamp = 0L;
            int achievedQuests = 0;
            int totalAchievedQuests = 0;
            try (Connection connection = this.sqlManager.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(SQLQuery.LOAD_PLAYER.getQuery());){
                preparedStatement.setString(1, playerUuid);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    Debugger.write("Executing query for player " + playerName + ": " + SQLQuery.LOAD_PLAYER.getQuery());
                    if (resultSet.next()) {
                        hasStoredData = true;
                        timestamp = resultSet.getLong("player_timestamp");
                        achievedQuests = resultSet.getInt("achieved_quests");
                        totalAchievedQuests = resultSet.getInt("total_achieved_quests");
                        Debugger.write(playerName + " has stored data.");
                    } else {
                        Debugger.write(playerName + " has no stored data.");
                    }
                }
                Debugger.write("Database connection closed.");
            }
            catch (SQLException e) {
                this.error(playerName, e.getMessage());
            }
            if (hasStoredData) {
                this.loadStoredData(player, activeQuests, timestamp, totalAchievedQuests, quests, achievedQuests);
            } else {
                QuestLoaderUtils.loadNewPlayerQuests(playerName, activeQuests, new HashMap<String, Integer>(), 0);
            }
        }, Duration.ofMillis(PlayerDataLoadDelay.getDelay()));
    }

    private void loadStoredData(Player player, Map<String, PlayerQuests> activeQuests, long timestamp, int totalAchievedQuests, LinkedHashMap<AbstractQuest, Progression> quests, int achievedQuests) {
        String playerName = player.getName();
        Debugger.write(playerName + " has data in the database.");
        Map<String, Integer> categoryStats = this.loadCategoryStats(player.getUniqueId().toString());
        if (QuestLoaderUtils.checkTimestamp(timestamp)) {
            QuestLoaderUtils.loadNewPlayerQuests(playerName, activeQuests, categoryStats, totalAchievedQuests);
        } else {
            if (!this.loadPlayerQuests(player, quests)) {
                QuestLoaderUtils.loadNewPlayerQuests(playerName, activeQuests, categoryStats, totalAchievedQuests);
                return;
            }
            PlayerQuests playerQuests = new PlayerQuests(timestamp, quests);
            playerQuests.setAchievedQuests(achievedQuests);
            playerQuests.setTotalAchievedQuests(totalAchievedQuests);
            playerQuests.setTotalAchievedQuestsByCategory(categoryStats);
            activeQuests.put(playerName, playerQuests);
            if (Logs.isEnabled()) {
                PluginLogger.info(playerName + "'s quests have been loaded.");
            }
            this.sendQuestStatusMessage(player, achievedQuests, playerQuests);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadPlayerQuests(Player player, LinkedHashMap<AbstractQuest, Progression> quests) {
        String playerName = player.getName();
        Debugger.write("Entering loadPlayerQuests method for player " + playerName + ".");
        try (Connection connection = this.sqlManager.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(SQLQuery.LOAD_PROGRESS.getQuery());){
            preparedStatement.setString(1, player.getUniqueId().toString());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                int id = 1;
                if (resultSet.next()) {
                    do {
                        int questIndex = resultSet.getInt("quest_index");
                        int advancement = resultSet.getInt("advancement");
                        int requiredAmount = resultSet.getInt("required_amount");
                        int selectedRequired = resultSet.getInt("selected_required");
                        if (resultSet.wasNull()) {
                            selectedRequired = -1;
                        }
                        if (requiredAmount == 0) {
                            this.requiredAmountIsZero(playerName);
                            boolean bl = false;
                            return bl;
                        }
                        boolean isAchieved = resultSet.getBoolean("is_achieved");
                        AbstractQuest quest = QuestLoaderUtils.findQuest(playerName, questIndex, id);
                        if (quest == null) {
                            Debugger.write("Quest " + id + " does not exist. New quests will be drawn.");
                            boolean bl = false;
                            return bl;
                        }
                        if (!quest.isRandomRequiredAmount() && requiredAmount != Integer.parseInt(quest.getRequiredAmountRaw())) {
                            this.requiredAmountNotEqual(playerName);
                            boolean bl = false;
                            return bl;
                        }
                        if (this.isSelectedRequiredInvalid(quest, selectedRequired, playerName)) {
                            boolean bl = false;
                            return bl;
                        }
                        Progression progression = new Progression(requiredAmount, advancement, isAchieved);
                        if (selectedRequired != -1) {
                            progression.setSelectedRequiredIndex(selectedRequired);
                        }
                        quests.put(quest, progression);
                    } while (resultSet.next() && ++id <= QuestsPerCategory.getTotalQuestsAmount());
                    if (resultSet.next()) {
                        this.logExcessQuests(playerName);
                    }
                }
                if (id - 1 < QuestsPerCategory.getTotalQuestsAmount()) {
                    PluginLogger.warn("Player " + playerName + " has less quests than expected. New quests will be drawn.");
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (SQLException e) {
            this.error(playerName, e.getMessage());
        }
        Debugger.write("Quests of player " + playerName + " have been loaded.");
        return true;
    }

    private Map<String, Integer> loadCategoryStats(String playerUuid) {
        HashMap<String, Integer> categoryStats = new HashMap<String, Integer>();
        try (Connection connection = this.sqlManager.getConnection();
             PreparedStatement statement = connection.prepareStatement(SQLQuery.LOAD_PLAYER_CATEGORY_STATS.getQuery());){
            statement.setString(1, playerUuid);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String category = resultSet.getString("category");
                    int count = resultSet.getInt("total_achieved_quests");
                    categoryStats.put(category, count);
                }
            }
        }
        catch (SQLException e) {
            PluginLogger.error("Failed to load category stats for player " + playerUuid + ": " + e.getMessage());
        }
        return categoryStats;
    }
}

