/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.storage.sql;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Database;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.essentials.Logs;
import com.ordwen.odailyquests.enums.SQLQuery;
import com.ordwen.odailyquests.enums.StorageMode;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.storage.sql.SQLManager;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;

public class SaveProgressionSQL {
    private final SQLManager sqlManager;

    public SaveProgressionSQL(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public void saveProgression(String playerName, String playerUuid, PlayerQuests playerQuests, boolean isServerStopping) {
        if (playerQuests == null) {
            PluginLogger.warn("Impossible to save progression for player " + playerName + " because playerQuests is null.");
            PluginLogger.warn("It can happen if the server is starting/reloading and the player's quests are not loaded yet.");
            return;
        }
        Debugger.write("Entering saveProgression method for player " + playerName);
        long timestamp = playerQuests.getTimestamp();
        int achievedQuests = playerQuests.getAchievedQuests();
        int totalAchievedQuests = playerQuests.getTotalAchievedQuests();
        Map<AbstractQuest, Progression> quests = playerQuests.getQuests();
        Map<String, Integer> totalAchievedByCategory = playerQuests.getTotalAchievedQuestsByCategory();
        if (isServerStopping) {
            Debugger.write("Saving player " + playerName + " progression (server is stopping or migration is in progress).");
            this.saveDatas(playerName, playerUuid, timestamp, achievedQuests, totalAchievedQuests, quests, totalAchievedByCategory);
        } else {
            ODailyQuests.morePaperLib.scheduling().asyncScheduler().run(() -> {
                Debugger.write("Saving player " + playerName + " progression asynchronously");
                this.saveDatas(playerName, playerUuid, timestamp, achievedQuests, totalAchievedQuests, quests, totalAchievedByCategory);
            });
        }
    }

    private void saveDatas(String playerName, String playerUuid, long timestamp, int achievedQuests, int totalAchievedQuests, Map<AbstractQuest, Progression> quests, Map<String, Integer> totalAchievedByCategory) {
        try (Connection conn = this.sqlManager.getConnection();){
            if (conn == null) {
                PluginLogger.error("Database connection unavailable");
                return;
            }
            String playerQuery = Database.getMode() == StorageMode.MYSQL ? SQLQuery.MYSQL_SAVE_PLAYER.getQuery() : SQLQuery.SQLITE_SAVE_PLAYER.getQuery();
            try (PreparedStatement playerStatement = conn.prepareStatement(playerQuery);){
                playerStatement.setString(1, playerUuid);
                playerStatement.setLong(2, timestamp);
                playerStatement.setInt(3, achievedQuests);
                playerStatement.setInt(4, totalAchievedQuests);
                playerStatement.executeUpdate();
                Debugger.write("Player " + playerName + " data saved");
            }
            String progressQuery = Database.getMode() == StorageMode.MYSQL ? SQLQuery.MYSQL_SAVE_PROGRESS.getQuery() : SQLQuery.SQLITE_SAVE_PROGRESS.getQuery();
            try (PreparedStatement progressionStatement = conn.prepareStatement(progressQuery);){
                progressionStatement.setString(1, playerUuid);
                int index = 0;
                for (Map.Entry<AbstractQuest, Progression> entry : quests.entrySet()) {
                    AbstractQuest quest = entry.getKey();
                    Progression progression = entry.getValue();
                    progressionStatement.setInt(2, index);
                    progressionStatement.setInt(3, quest.getQuestIndex());
                    progressionStatement.setInt(4, progression.getAdvancement());
                    progressionStatement.setInt(5, progression.getRequiredAmount());
                    progressionStatement.setBoolean(6, progression.isAchieved());
                    progressionStatement.setInt(7, progression.getSelectedRequiredIndex());
                    progressionStatement.addBatch();
                    Debugger.write("Quest number " + index + " saved for player " + playerName);
                    ++index;
                }
                progressionStatement.executeBatch();
                Debugger.write(playerName + " quests progression saved");
            }
            String categoryQuery = Database.getMode() == StorageMode.MYSQL ? SQLQuery.MYSQL_SAVE_PLAYER_CATEGORY_STATS.getQuery() : SQLQuery.SQLITE_SAVE_PLAYER_CATEGORY_STATS.getQuery();
            try (PreparedStatement categoryStatement = conn.prepareStatement(categoryQuery);){
                categoryStatement.setString(1, playerUuid);
                for (Map.Entry<Object, Object> entry : totalAchievedByCategory.entrySet()) {
                    categoryStatement.setString(2, (String)entry.getKey());
                    categoryStatement.setInt(3, (Integer)entry.getValue());
                    categoryStatement.addBatch();
                }
                categoryStatement.executeBatch();
                Debugger.write(playerName + "'s category stats saved.");
            }
            if (Logs.isEnabled()) {
                PluginLogger.info(playerName + "'s data saved.");
            }
        }
        catch (SQLException e) {
            Debugger.write("An error occurred while saving player " + playerName + " data.");
            Debugger.write(e.getMessage());
            PluginLogger.error("An error occurred while saving player " + playerName + " data.");
            PluginLogger.error(e.getMessage());
        }
    }
}

