/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.storage.sql.mysql;

import com.ordwen.odailyquests.configuration.essentials.Database;
import com.ordwen.odailyquests.quests.player.progression.storage.sql.LoadProgressionSQL;
import com.ordwen.odailyquests.quests.player.progression.storage.sql.SQLManager;
import com.ordwen.odailyquests.quests.player.progression.storage.sql.SaveProgressionSQL;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;

public class MySQLManager
extends SQLManager {
    public MySQLManager() {
        this.loadProgressionSQL = new LoadProgressionSQL(this);
        this.saveProgressionSQL = new SaveProgressionSQL(this);
        this.setupDatabase();
    }

    public void initHikariCP() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setMaximumPoolSize(10);
        hikariConfig.setJdbcUrl(this.toUri());
        hikariConfig.setUsername(Database.getUser());
        hikariConfig.setPassword(Database.getPassword());
        hikariConfig.setMaxLifetime(300000L);
        hikariConfig.setLeakDetectionThreshold(10000L);
        hikariConfig.setConnectionTimeout(10000L);
        this.hikariDataSource = new HikariDataSource(hikariConfig);
    }

    public void setupDatabase() {
        this.initHikariCP();
        this.testConnection();
        this.setupTables();
    }

    private String toUri() {
        return "jdbc:mysql://" + Database.getHost() + ":" + Database.getPort() + "/" + Database.getName();
    }
}

