/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.storage.yaml;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.essentials.Logs;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.files.implementations.ProgressionFile;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.ProgressionLoader;
import com.ordwen.odailyquests.quests.player.progression.QuestLoaderUtils;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class LoadProgressionYAML
extends ProgressionLoader {
    private final ProgressionFile progressionFile;

    public LoadProgressionYAML(ProgressionFile progressionFile) {
        this.progressionFile = progressionFile;
    }

    public void loadPlayerQuests(String playerName, Map<String, PlayerQuests> activeQuests) {
        Debugger.write("Entering loadPlayerQuests (YAML) method for player " + playerName + ".");
        ODailyQuests.morePaperLib.scheduling().asyncScheduler().run(() -> {
            Debugger.write("Running async task to load progression of " + playerName + " from YAML file.");
            FileConfiguration config = this.progressionFile.getConfig();
            Player player = Bukkit.getPlayer((String)playerName);
            if (player == null) {
                this.handlePlayerDisconnected(playerName);
                return;
            }
            String playerUuid = player.getUniqueId().toString();
            ConfigurationSection playerSection = config.getConfigurationSection(playerUuid);
            if (playerSection == null) {
                this.handleNewPlayer(playerName, activeQuests);
                return;
            }
            this.loadExistingPlayerData(playerName, activeQuests, player, playerSection);
        });
    }

    private void loadExistingPlayerData(String playerName, Map<String, PlayerQuests> activeQuests, Player player, ConfigurationSection playerSection) {
        Debugger.write("Player " + playerName + " has data in progression file.");
        long timestamp = playerSection.getLong(".timestamp");
        int achievedQuests = playerSection.getInt(".achievedQuests");
        int totalAchievedQuests = playerSection.getInt(".totalAchievedQuests");
        HashMap<String, Integer> totalAchievedQuestsByCategory = new HashMap<String, Integer>();
        ConfigurationSection statsSection = playerSection.getConfigurationSection("totalAchievedQuestsByCategory");
        if (statsSection != null) {
            for (String category : statsSection.getKeys(false)) {
                totalAchievedQuestsByCategory.put(category, statsSection.getInt(category));
            }
        }
        if (QuestLoaderUtils.checkTimestamp(timestamp)) {
            Debugger.write("Timestamp is too old for player " + playerName + ". New quests will be drawn.");
            QuestLoaderUtils.loadNewPlayerQuests(playerName, activeQuests, totalAchievedQuestsByCategory, totalAchievedQuests);
            return;
        }
        LinkedHashMap<AbstractQuest, Progression> quests = this.loadPlayerQuestsFromConfig(playerName, playerSection);
        if (quests == null) {
            QuestLoaderUtils.loadNewPlayerQuests(playerName, activeQuests, totalAchievedQuestsByCategory, totalAchievedQuests);
            return;
        }
        PlayerQuests playerQuests = new PlayerQuests(timestamp, quests);
        playerQuests.setAchievedQuests(achievedQuests);
        playerQuests.setTotalAchievedQuests(totalAchievedQuests);
        playerQuests.setTotalAchievedQuestsByCategory(totalAchievedQuestsByCategory);
        activeQuests.put(playerName, playerQuests);
        if (Logs.isEnabled()) {
            PluginLogger.info(playerName + "'s quests have been loaded.");
        }
        this.sendQuestStatusMessage(player, achievedQuests, playerQuests);
    }

    private LinkedHashMap<AbstractQuest, Progression> loadPlayerQuestsFromConfig(String playerName, ConfigurationSection playerSection) {
        LinkedHashMap<AbstractQuest, Progression> quests = new LinkedHashMap<AbstractQuest, Progression>();
        ConfigurationSection questsSection = playerSection.getConfigurationSection(".quests");
        if (questsSection == null) {
            this.handleMissingQuests(playerName);
            return quests;
        }
        int i = 1;
        for (String key : questsSection.getKeys(false)) {
            if (i > QuestsPerCategory.getTotalQuestsAmount()) {
                this.logExcessQuests(playerName);
                break;
            }
            int questIndex = questsSection.getInt(key + ".index");
            int advancement = questsSection.getInt(key + ".progression");
            int requiredAmount = questsSection.getInt(key + ".requiredAmount");
            int selectedRequired = questsSection.getInt(key + ".selectedRequired", -1);
            if (requiredAmount == 0) {
                this.requiredAmountIsZero(playerName);
                return null;
            }
            boolean isAchieved = questsSection.getBoolean(key + ".isAchieved");
            AbstractQuest quest = QuestLoaderUtils.findQuest(playerName, questIndex, Integer.parseInt(key));
            if (quest == null) {
                Debugger.write("Quest " + questIndex + " does not exist. New quests will be drawn.");
                return null;
            }
            if (!quest.isRandomRequired() && requiredAmount != Integer.parseInt(quest.getRequiredAmountRaw())) {
                this.requiredAmountNotEqual(playerName);
                return null;
            }
            if (this.isSelectedRequiredInvalid(quest, selectedRequired, playerName)) {
                return null;
            }
            Progression progression = new Progression(requiredAmount, advancement, isAchieved);
            if (selectedRequired != -1) {
                progression.setSelectedRequiredIndex(selectedRequired);
            }
            quests.put(quest, progression);
            ++i;
        }
        return quests;
    }
}

