/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.player.progression.storage.yaml;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Logs;
import com.ordwen.odailyquests.files.implementations.ProgressionFile;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.io.IOException;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class SaveProgressionYAML {
    private final ProgressionFile progressionFile;

    public SaveProgressionYAML(ProgressionFile progressionFile) {
        this.progressionFile = progressionFile;
    }

    public void saveProgression(String playerName, String playerUuid, PlayerQuests playerQuests, boolean isServerStopping) {
        if (isServerStopping) {
            this.updateFile(playerName, playerUuid, playerQuests);
        } else {
            ODailyQuests.morePaperLib.scheduling().asyncScheduler().run(() -> this.updateFile(playerName, playerUuid, playerQuests));
        }
    }

    private void updateFile(String playerName, String playerUuid, PlayerQuests playerQuests) {
        FileConfiguration config = this.progressionFile.getConfig();
        long timestamp = playerQuests.getTimestamp();
        int achievedQuests = playerQuests.getAchievedQuests();
        int totalAchievedQuests = playerQuests.getTotalAchievedQuests();
        Map<AbstractQuest, Progression> quests = playerQuests.getQuests();
        config.set(playerUuid + ".timestamp", (Object)timestamp);
        config.set(playerUuid + ".achievedQuests", (Object)achievedQuests);
        config.set(playerUuid + ".totalAchievedQuests", (Object)totalAchievedQuests);
        int index = 1;
        for (Map.Entry<AbstractQuest, Progression> entry : quests.entrySet()) {
            AbstractQuest abstractQuest = entry.getKey();
            Progression progression = entry.getValue();
            ConfigurationSection questSection = config.createSection(playerUuid + ".quests." + index);
            questSection.set("index", (Object)abstractQuest.getQuestIndex());
            questSection.set("progression", (Object)progression.getAdvancement());
            questSection.set("requiredAmount", (Object)progression.getRequiredAmount());
            questSection.set("selectedRequired", (Object)progression.getSelectedRequiredIndex());
            questSection.set("isAchieved", (Object)progression.isAchieved());
            ++index;
        }
        ConfigurationSection statsSection = config.createSection(playerUuid + ".totalAchievedQuestsByCategory");
        for (Map.Entry<String, Integer> entry : playerQuests.getTotalAchievedQuestsByCategory().entrySet()) {
            String category = entry.getKey();
            int amount = entry.getValue();
            statsSection.set(category, (Object)amount);
        }
        if (Logs.isEnabled()) {
            PluginLogger.info(playerName + "'s data saved.");
        }
        try {
            config.save(this.progressionFile.getFile());
        }
        catch (IOException iOException) {
            PluginLogger.error("An error happened on the save of the progression file.");
            PluginLogger.error("If the problem persists, contact the developer.");
            PluginLogger.error(iOException.getMessage());
        }
    }
}

