/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types;

import com.ordwen.odailyquests.api.quests.IQuest;
import com.ordwen.odailyquests.quests.conditions.placeholder.PlaceholderCondition;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.rewards.Reward;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractQuest
extends PlayerProgressor
implements IQuest {
    final int questIndex;
    final String fileIndex;
    final String questName;
    final String categoryName;
    final List<String> questDesc;
    final String questType;
    final ItemStack menuItem;
    final int menuItemAmount;
    final ItemStack achievedItem;
    final String requiredAmountRaw;
    final Reward reward;
    final List<String> requiredWorlds;
    final List<String> requiredRegions;
    final boolean protectionBypass;
    final List<String> requiredPermissions;
    protected boolean isRandomRequired;
    protected final List<String> displayNames;
    private List<PlaceholderCondition> placeholderConditions;

    protected AbstractQuest(int questIndex, String fileIndex, String questName, String categoryName, List<String> questDesc, String questType, ItemStack menuItem, int menuItemAmount, ItemStack achievedItem, String requiredAmountRaw, Reward reward, List<String> requiredWorlds, List<String> requiredRegions, boolean protectionBypass, List<String> requiredPermissions, List<PlaceholderCondition> placeholderConditions) {
        this.questIndex = questIndex;
        this.fileIndex = fileIndex;
        this.questName = questName;
        this.categoryName = categoryName;
        this.questDesc = questDesc;
        this.questType = questType;
        this.menuItem = menuItem;
        this.menuItemAmount = menuItemAmount;
        this.achievedItem = achievedItem;
        this.requiredAmountRaw = requiredAmountRaw;
        this.reward = reward;
        this.requiredWorlds = requiredWorlds;
        this.requiredRegions = requiredRegions;
        this.protectionBypass = protectionBypass;
        this.requiredPermissions = requiredPermissions;
        this.placeholderConditions = placeholderConditions;
        this.displayNames = new ArrayList<String>();
    }

    protected AbstractQuest(BasicQuest basicQuest) {
        this.questIndex = basicQuest.getQuestIndex();
        this.fileIndex = basicQuest.getFileIndex();
        this.questName = basicQuest.getQuestName();
        this.categoryName = basicQuest.getCategoryName();
        this.questDesc = basicQuest.getQuestDesc();
        this.questType = basicQuest.getQuestType();
        this.menuItem = basicQuest.getMenuItem();
        this.menuItemAmount = basicQuest.getMenuItemAmount();
        this.achievedItem = basicQuest.getAchievedItem();
        this.requiredAmountRaw = basicQuest.getRequiredAmountRaw();
        this.reward = basicQuest.getReward();
        this.requiredWorlds = basicQuest.getRequiredWorlds();
        this.requiredRegions = basicQuest.getRequiredRegions();
        this.protectionBypass = basicQuest.isProtectionBypass();
        this.requiredPermissions = basicQuest.getRequiredPermissions();
        this.placeholderConditions = basicQuest.getPlaceholderConditions();
        this.displayNames = new ArrayList<String>();
    }

    public String getSelectedDisplayName(int index) {
        if (!this.isRandomRequired || this.displayNames.isEmpty()) {
            return String.valueOf(ChatColor.RED) + "Invalid usage.";
        }
        if (index < 0 || index >= this.displayNames.size()) {
            return String.valueOf(ChatColor.RED) + "Invalid index.";
        }
        return this.displayNames.get(index);
    }

    protected boolean isDisplayNameMissing(ConfigurationSection section, String file, String index, String path, String type) {
        if (path.equals(".random_required")) {
            String displayName = section.getString(path + "." + type);
            if (displayName == null || displayName.isEmpty()) {
                PluginLogger.configurationError(file, index, path + "." + type, "Missing display name for random required item.");
                return true;
            }
            this.displayNames.add(displayName);
        }
        return false;
    }

    public int getQuestIndex() {
        return this.questIndex;
    }

    public String getFileIndex() {
        return this.fileIndex;
    }

    public String getQuestType() {
        return this.questType;
    }

    public String getQuestName() {
        return this.questName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public ItemStack getMenuItem() {
        return this.menuItem;
    }

    public int getMenuItemAmount() {
        return this.menuItemAmount;
    }

    public ItemStack getAchievedItem() {
        return this.achievedItem;
    }

    public List<String> getQuestDesc() {
        return this.questDesc;
    }

    public String getRequiredAmountRaw() {
        return this.requiredAmountRaw;
    }

    public Reward getReward() {
        return this.reward;
    }

    public List<String> getRequiredWorlds() {
        return this.requiredWorlds;
    }

    public List<String> getRequiredRegions() {
        return this.requiredRegions;
    }

    public boolean isProtectionBypass() {
        return this.protectionBypass;
    }

    public List<String> getRequiredPermissions() {
        return this.requiredPermissions;
    }

    public boolean isRandomRequired() {
        return this.isRandomRequired;
    }

    public boolean isRandomRequiredAmount() {
        return this.requiredAmountRaw.contains("-");
    }

    public List<PlaceholderCondition> getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    public boolean hasPlaceholderConditions() {
        return !this.placeholderConditions.isEmpty();
    }
}

