/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.custom.crate;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.PluginUtils;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentcrates.api.event.CrateOpenEvent;

public class CrateOpenQuest
extends AbstractQuest {
    private static final String REQUIRED = "required";
    private final Set<String> expectedCrate = new HashSet<String>();

    public CrateOpenQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public String getType() {
        return "CRATE_OPEN";
    }

    @Override
    public boolean canProgress(@Nullable Event provided, Progression progression) {
        if (provided instanceof CrateOpenEvent) {
            CrateOpenEvent event = (CrateOpenEvent)provided;
            String crate = event.getCrate().getName();
            Debugger.write("CrateOpenQuest: canProgress checking crate " + crate);
            return this.expectedCrate.isEmpty() || this.expectedCrate.contains(crate.toLowerCase());
        }
        return false;
    }

    @Override
    public boolean loadParameters(ConfigurationSection section, String file, String index) {
        this.expectedCrate.clear();
        if (!PluginUtils.isPluginEnabled("ExcellentCrates")) {
            PluginLogger.configurationError(file, index, null, "You must have ExcellentCrates installed to use this quest.");
            return false;
        }
        if (section.isList(REQUIRED)) {
            for (String crate : section.getStringList(REQUIRED)) {
                this.expectedCrate.add(crate.toLowerCase());
            }
        } else if (section.isString(REQUIRED)) {
            String crate = section.getString(REQUIRED);
            this.expectedCrate.add(crate.toLowerCase());
        }
        return true;
    }
}

