/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.entity;

import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.quests.types.shared.EntityQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class ShearQuest
extends EntityQuest {
    public ShearQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public String getType() {
        return "SHEAR";
    }

    @Override
    public boolean loadParameters(ConfigurationSection section, String file, String index) {
        if (!super.loadParameters(section, file, index)) {
            return false;
        }
        this.dyeColor = this.getDyeColor(section, file, index);
        return true;
    }

    @Override
    public boolean canProgress(Event provided, Progression progression) {
        if (provided instanceof PlayerShearEntityEvent) {
            PlayerShearEntityEvent event = (PlayerShearEntityEvent)provided;
            if (!this.isRequiredEntity(event.getEntity().getType(), progression)) {
                return false;
            }
            Entity entity = event.getEntity();
            if (entity instanceof Sheep) {
                Sheep sheep = (Sheep)entity;
                if (this.dyeColor == null) {
                    return true;
                }
                return sheep.getColor() == this.dyeColor;
            }
            return true;
        }
        return false;
    }

    private DyeColor getDyeColor(ConfigurationSection section, String file, String index) {
        String expected = section.getString(".sheep_color");
        if (expected == null) {
            return null;
        }
        try {
            return DyeColor.valueOf((String)expected.toUpperCase());
        }
        catch (Exception e) {
            PluginLogger.configurationError(file, index, "sheep_color", "Invalid dye type detected.");
            return null;
        }
    }
}

