/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.inventory;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.quests.conditions.ConditionOperator;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlaceholderQuest
extends AbstractQuest {
    private String placeholder;
    private ConditionOperator conditionOperator;
    private String expectedValue;
    private String errorMessage;

    public PlaceholderQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public String getType() {
        return "PLACEHOLDER";
    }

    @Override
    public boolean canProgress(Event provided, Progression progression) {
        return false;
    }

    @Override
    public boolean loadParameters(ConfigurationSection section, String file, String index) {
        ConfigurationSection placeholderSection = section.getConfigurationSection(".placeholder");
        if (placeholderSection == null) {
            PluginLogger.configurationError(file, index, "placeholder", "The placeholder section is missing.");
            return false;
        }
        this.placeholder = placeholderSection.getString(".value");
        if (this.placeholder == null) {
            PluginLogger.configurationError(file, index, "value", "The value of the placeholder is missing.");
            return false;
        }
        String operator = placeholderSection.getString(".operator");
        if (operator == null) {
            PluginLogger.configurationError(file, index, "operator", "The operator of the placeholder is missing.");
            return false;
        }
        try {
            this.conditionOperator = ConditionOperator.valueOf(operator.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            PluginLogger.configurationError(file, index, "operator", operator + " is not a valid operator.");
            return false;
        }
        this.expectedValue = placeholderSection.getString(".expected");
        if (this.expectedValue == null) {
            PluginLogger.configurationError(file, index, "expected", "The expected value of the placeholder is missing.");
            return false;
        }
        this.errorMessage = placeholderSection.getString(".error_message");
        if (this.errorMessage == null) {
            PluginLogger.configurationError(file, index, "error_message", "The error message of the placeholder is missing.");
            return false;
        }
        ItemStack menuItem = super.getMenuItem();
        ItemMeta meta = menuItem.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(new NamespacedKey((Plugin)ODailyQuests.INSTANCE, "quest_type"), PersistentDataType.STRING, (Object)"placeholder");
        container.set(new NamespacedKey((Plugin)ODailyQuests.INSTANCE, "quest_index"), PersistentDataType.STRING, (Object)index);
        container.set(new NamespacedKey((Plugin)ODailyQuests.INSTANCE, "file_name"), PersistentDataType.STRING, (Object)file);
        return true;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public ConditionOperator getConditionType() {
        return this.conditionOperator;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

