/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.quests.types.item;

import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.shared.BasicQuest;
import com.ordwen.odailyquests.quests.types.shared.ItemQuest;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class ConsumeQuest
extends ItemQuest {
    public ConsumeQuest(BasicQuest base) {
        super(base);
    }

    @Override
    public String getType() {
        return "CONSUME";
    }

    @Override
    public boolean canProgress(Event provided, Progression progression) {
        EntityResurrectEvent event;
        EntityEquipment equipment;
        if (provided instanceof PlayerItemConsumeEvent) {
            PlayerItemConsumeEvent event2 = (PlayerItemConsumeEvent)provided;
            return super.isRequiredItem(event2.getItem(), progression);
        }
        if (provided instanceof EntityResurrectEvent && (equipment = (event = (EntityResurrectEvent)provided).getEntity().getEquipment()) != null) {
            ItemStack mainHand = equipment.getItemInMainHand();
            ItemStack offHand = equipment.getItemInOffHand();
            if (mainHand.getType() == Material.TOTEM_OF_UNDYING) {
                return super.isRequiredItem(mainHand, progression);
            }
            if (offHand.getType() == Material.TOTEM_OF_UNDYING) {
                return super.isRequiredItem(offHand, progression);
            }
        }
        return false;
    }
}

