/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.rewards;

import com.ordwen.odailyquests.rewards.Reward;
import com.ordwen.odailyquests.rewards.RewardType;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import org.bukkit.configuration.ConfigurationSection;

public class RewardLoader {
    public Reward getRewardFromSection(ConfigurationSection section, String fileName, String questIndex) {
        RewardType rewardType;
        try {
            rewardType = RewardType.valueOf(section.getString(".reward_type"));
        }
        catch (Exception e) {
            this.configurationError(fileName, "reward_type", section.getString(".reward_type") + " is not a valid reward type.", questIndex);
            rewardType = RewardType.NONE;
        }
        String message = TextFormatter.format(section.getString(".message"));
        return switch (rewardType) {
            case RewardType.NONE -> {
                Reward var6_7;
                yield var6_7 = new Reward(RewardType.NONE, 0.0, message);
            }
            case RewardType.COMMAND -> {
                Reward var6_8;
                yield var6_8 = new Reward(RewardType.COMMAND, section.getStringList(".commands"), message);
            }
            case RewardType.COINS_ENGINE -> {
                Reward var6_12;
                int parsedAmount;
                String currencyLabel = section.getString(".currency_label");
                String currencyDisplayName = section.getString(".currency_display_name");
                if (currencyLabel == null || currencyDisplayName == null) {
                    Reward var6_9;
                    PluginLogger.error("Currency label or currency display name is missing in the configuration file.");
                    yield var6_9 = new Reward(RewardType.NONE, 0.0, message);
                }
                String amount = section.getString(".amount");
                if (amount == null || amount.isEmpty()) {
                    Reward var6_10;
                    PluginLogger.error("Amount is missing in the configuration file for COINS_ENGINE reward.");
                    yield var6_10 = new Reward(RewardType.NONE, 0.0, message);
                }
                try {
                    parsedAmount = Integer.parseInt(TextFormatter.format(amount));
                }
                catch (NumberFormatException e) {
                    Reward var6_11;
                    PluginLogger.error("Amount is not a valid integer in the configuration file for COINS_ENGINE reward.");
                    yield var6_11 = new Reward(RewardType.NONE, 0.0, message);
                }
                yield var6_12 = new Reward(RewardType.COINS_ENGINE, currencyLabel, currencyDisplayName, parsedAmount, message);
            }
            default -> {
                Reward var6_15;
                double parsedAmount;
                String amount = section.getString(".amount");
                if (amount == null || amount.isEmpty()) {
                    Reward var6_13;
                    PluginLogger.error("Amount is missing in the configuration file for COINS_ENGINE reward.");
                    yield var6_13 = new Reward(RewardType.NONE, 0.0, message);
                }
                try {
                    parsedAmount = Double.parseDouble(TextFormatter.format(amount));
                }
                catch (NumberFormatException e) {
                    Reward var6_14;
                    PluginLogger.error("Amount is not a valid number in the configuration file for " + String.valueOf((Object)rewardType) + " reward.");
                    yield var6_14 = new Reward(RewardType.NONE, 0.0, message);
                }
                yield var6_15 = new Reward(rewardType, parsedAmount, message);
            }
        };
    }

    public void configurationError(String fileName, String parameter, String reason, String questIndex) {
        PluginLogger.error("-----------------------------------");
        PluginLogger.error("Invalid reward configuration detected.");
        PluginLogger.error("File : " + fileName);
        PluginLogger.error("Reason : " + reason);
        if (parameter != null) {
            PluginLogger.error("Parameter : " + parameter);
        }
        if (questIndex != null) {
            PluginLogger.error("Quest index : " + questIndex);
        }
        PluginLogger.error("-----------------------------------");
    }
}

