/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.rewards;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.functionalities.progression.ActionBar;
import com.ordwen.odailyquests.configuration.functionalities.progression.Title;
import com.ordwen.odailyquests.configuration.functionalities.progression.ToastNotification;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.externs.hooks.eco.VaultHook;
import com.ordwen.odailyquests.externs.hooks.points.PlayerPointsHook;
import com.ordwen.odailyquests.externs.hooks.points.TokenManagerHook;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.rewards.Reward;
import com.ordwen.odailyquests.rewards.RewardType;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.PluginUtils;
import com.ordwen.odailyquests.tools.TextFormatter;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;

public class RewardManager {
    private static final String REWARD_AMOUNT = "%rewardAmount%";

    private RewardManager() {
    }

    public static void sendQuestRewardItems(String questName, Player player, Reward reward, Progression progression) {
        Debugger.write("RewardManager: sendAllRewardItems summoned by " + player.getName() + " for " + questName + ".");
        String msg = QuestsMessages.QUEST_ACHIEVED.getMessage(player, Map.of("%questName%", questName));
        if (msg != null) {
            player.sendMessage(msg);
        }
        Title.sendTitle(player, questName);
        ToastNotification.sendToastNotification(player, questName);
        ActionBar.sendActionbar(player, questName);
        Map<String, String> placeholders = Map.of("%required%", String.valueOf(progression.getRequiredAmount()), "%questName%", questName);
        RewardManager.sendReward(player, reward, placeholders);
    }

    public static void sendReward(Player player, Reward reward, Map<String, String> placeholders) {
        if (reward.getRewardType() == RewardType.NONE) {
            return;
        }
        Debugger.write("RewardManager: sendQuestReward summoned by " + player.getName() + " for " + String.valueOf((Object)reward.getRewardType()));
        switch (reward.getRewardType()) {
            case COMMAND: {
                RewardManager.handleCommandReward(player, reward, placeholders);
                break;
            }
            case EXP_LEVELS: {
                RewardManager.handleExpLevelsReward(player, reward);
                break;
            }
            case EXP_POINTS: {
                RewardManager.handleExpPointsReward(player, reward);
                break;
            }
            case MONEY: {
                RewardManager.handleMoneyReward(player, reward);
                break;
            }
            case POINTS: {
                RewardManager.handlePointsReward(player, reward);
                break;
            }
            case COINS_ENGINE: {
                RewardManager.handleCoinsEngineReward(player, reward);
                break;
            }
            default: {
                RewardManager.rewardTypeError(player, reward.getRewardType());
            }
        }
        String custom = reward.getMessage();
        if (custom != null && !custom.isEmpty()) {
            player.sendMessage(TextFormatter.format(custom.replace("%player%", player.getName())));
        }
    }

    private static void handleCommandReward(Player player, Reward reward, Map<String, String> placeholders) {
        for (String raw : reward.getRewardCommands()) {
            String cmd = RewardManager.expandPlaceholders(player, raw, placeholders);
            ODailyQuests.morePaperLib.scheduling().globalRegionalScheduler().run(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd));
        }
        RewardManager.sendMsg(player, QuestsMessages.REWARD_COMMAND);
    }

    private static void handleExpLevelsReward(Player player, Reward reward) {
        ODailyQuests.morePaperLib.scheduling().entitySpecificScheduler((Entity)player).run(() -> player.giveExpLevels((int)reward.getRewardAmount()), null);
        RewardManager.sendMsgAmount(player, QuestsMessages.REWARD_EXP_LEVELS, reward.getRewardAmount());
    }

    private static void handleExpPointsReward(Player player, Reward reward) {
        ODailyQuests.morePaperLib.scheduling().entitySpecificScheduler((Entity)player).run(() -> player.giveExp((int)reward.getRewardAmount()), null);
        RewardManager.sendMsgAmount(player, QuestsMessages.REWARD_EXP_POINTS, reward.getRewardAmount());
    }

    private static void handleMoneyReward(Player player, Reward reward) {
        if (VaultHook.getEconomy() == null) {
            RewardManager.rewardTypeErrorWithVault(player, reward.getRewardType());
            return;
        }
        VaultHook.getEconomy().depositPlayer((OfflinePlayer)player, reward.getRewardAmount());
        RewardManager.sendMsgAmount(player, QuestsMessages.REWARD_MONEY, reward.getRewardAmount());
    }

    private static void handlePointsReward(Player player, Reward reward) {
        if (TokenManagerHook.getTokenManagerAPI() != null) {
            TokenManagerHook.getTokenManagerAPI().addTokens(player, (long)((int)reward.getRewardAmount()));
            RewardManager.sendMsgAmount(player, QuestsMessages.REWARD_POINTS, reward.getRewardAmount());
            return;
        }
        if (PlayerPointsHook.isPlayerPointsSetup()) {
            PlayerPointsHook.getPlayerPointsAPI().give(player.getUniqueId(), (int)reward.getRewardAmount());
            RewardManager.sendMsgAmount(player, QuestsMessages.REWARD_POINTS, reward.getRewardAmount());
            return;
        }
        RewardManager.rewardTypeErrorNoPoints(player, reward.getRewardType());
    }

    private static void handleCoinsEngineReward(Player player, Reward reward) {
        if (!PluginUtils.isPluginEnabled("CoinsEngine")) {
            RewardManager.rewardTypeError(player, reward.getRewardType());
            return;
        }
        Currency currency = CoinsEngineAPI.getCurrency((String)reward.getRewardCurrency());
        if (currency == null) {
            RewardManager.currencyError(player, reward.getRewardCurrency());
            return;
        }
        CoinsEngineAPI.addBalance((Player)player, (Currency)currency, (double)reward.getRewardAmount());
        RewardManager.sendMsgAmountAndCurrency(player, QuestsMessages.REWARD_COINS_ENGINE, reward.getRewardAmount(), TextFormatter.format(reward.getRewardCurrencyDisplayName()));
    }

    private static String expandPlaceholders(Player player, String raw, Map<String, String> placeholders) {
        String s = TextFormatter.format(TextFormatter.format(player, raw)).replace("%player%", player.getName());
        if (placeholders == null || placeholders.isEmpty()) {
            return s;
        }
        for (Map.Entry<String, String> e : placeholders.entrySet()) {
            String k = e.getKey();
            String v = e.getValue();
            if (k == null || v == null) continue;
            s = s.replace(k, v);
        }
        return s;
    }

    private static void sendMsg(Player player, QuestsMessages qm) {
        String msg = qm.getMessage(player);
        if (msg != null) {
            player.sendMessage(msg);
        }
    }

    private static void sendMsgAmount(Player player, QuestsMessages qm, double amount) {
        String msg = qm.getMessage(player);
        if (msg != null) {
            player.sendMessage(msg.replace(REWARD_AMOUNT, String.valueOf(amount)));
        }
    }

    private static void sendMsgAmountAndCurrency(Player player, QuestsMessages qm, double amount, String currencyName) {
        String msg = qm.getMessage(player);
        if (msg != null) {
            player.sendMessage(msg.replace(REWARD_AMOUNT, String.valueOf(amount)).replace("%currencyName%", currencyName));
        }
    }

    private static void rewardTypeError(Player player, RewardType type) {
        PluginLogger.error("Impossible to give the reward to " + player.getName() + ".");
        PluginLogger.error("Reward type is " + String.valueOf((Object)type) + " but required plugin is not hooked.");
        player.sendMessage(String.valueOf(ChatColor.RED) + "Impossible to give you your reward. Please contact an administrator.");
    }

    private static void rewardTypeErrorWithVault(Player player, RewardType type) {
        PluginLogger.error("Impossible to give the reward to " + player.getName() + ".");
        PluginLogger.error("Reward type is " + String.valueOf((Object)type) + " but Vault is not hooked.");
        player.sendMessage(String.valueOf(ChatColor.RED) + "Impossible to give you your reward. Please contact an administrator.");
    }

    private static void rewardTypeErrorNoPoints(Player player, RewardType type) {
        PluginLogger.error("Impossible to give the reward to " + player.getName() + ".");
        PluginLogger.error("Reward type is " + String.valueOf((Object)type) + " but no points plugin is hooked.");
        player.sendMessage(String.valueOf(ChatColor.RED) + "Impossible to give you your reward. Please contact an administrator.");
    }

    private static void currencyError(Player player, String currency) {
        PluginLogger.error("Impossible to give the reward to " + player.getName() + ".");
        PluginLogger.error("CoinsEngine currency '" + currency + "' not found.");
        player.sendMessage(String.valueOf(ChatColor.RED) + "Impossible to give you your reward. Please contact an administrator.");
    }
}

