/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;

public class TextFormatter {
    private static final Pattern HEX_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");
    private static boolean placeholderAPIEnabled = false;

    private TextFormatter() {
    }

    public static void setPlaceholderAPIEnabled(boolean enabled) {
        placeholderAPIEnabled = enabled;
    }

    public static boolean isPlaceholderAPIEnabled() {
        return placeholderAPIEnabled;
    }

    public static String format(String message) {
        if (message == null) {
            return null;
        }
        return TextFormatter.replaceAll(message);
    }

    public static String format(Player player, String message) {
        if (message == null) {
            return null;
        }
        if (placeholderAPIEnabled) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        message = TextFormatter.replaceAll(message);
        return message;
    }

    private static String replaceAll(String message) {
        message = TextFormatter.applyHexColor(message);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    private static String applyHexColor(String message) {
        Matcher matcher = HEX_PATTERN.matcher(message);
        while (matcher.find()) {
            String hexCode = matcher.group();
            message = message.replace(hexCode, ChatColor.of((String)hexCode).toString());
            matcher = HEX_PATTERN.matcher(message);
        }
        return message;
    }
}

