/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools;

import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.configuration.essentials.RenewInterval;
import com.ordwen.odailyquests.configuration.essentials.RenewTime;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.QuestLoaderUtils;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TimerTask {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> scheduledTask;

    public TimerTask(LocalDateTime start) {
        this.scheduleNextExecution(start);
    }

    private void scheduleNextExecution(LocalDateTime start) {
        LocalTime renewTime = RenewTime.getRenewTime();
        Duration renewInterval = RenewInterval.getRenewInterval();
        ZoneId renewZoneId = RenewTime.getZoneId();
        ZonedDateTime zonedStart = start.atZone(ZoneId.systemDefault()).withZoneSameInstant(renewZoneId);
        ZonedDateTime nextExecution = zonedStart.with(renewTime);
        while (nextExecution.isBefore(zonedStart)) {
            nextExecution = nextExecution.plus(renewInterval);
        }
        long initialDelay = Duration.between(ZonedDateTime.now(ZoneId.systemDefault()), nextExecution.withZoneSameInstant(ZoneId.systemDefault())).toNanos();
        this.scheduledTask = this.scheduler.schedule(this::executeAndReschedule, initialDelay, TimeUnit.NANOSECONDS);
    }

    private void executeAndReschedule() {
        PluginLogger.info("It's a new day. The player quests are being reloaded.");
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            String msg = QuestsMessages.NEW_DAY.toString();
            if (!msg.isEmpty()) {
                player.sendMessage(msg);
            }
            PlayerQuests playerQuests = ODailyQuestsAPI.getPlayerQuests(player.getName());
            int totalAchievedQuests = playerQuests.getTotalAchievedQuests();
            Map<String, Integer> totalAchievedQuestsByCategory = playerQuests.getTotalAchievedQuestsByCategory();
            QuestLoaderUtils.loadNewPlayerQuests(player.getName(), QuestsManager.getActiveQuests(), totalAchievedQuestsByCategory, totalAchievedQuests);
        }
        this.scheduleNextExecution(LocalDateTime.now());
    }

    public void reload() {
        this.cancel();
        this.scheduleNextExecution(LocalDateTime.now());
    }

    private void cancel() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
        }
    }

    public void stop() {
        this.scheduler.shutdownNow();
    }
}

