/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools.updater.config;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.files.FilesManager;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.updater.config.IConfigUpdater;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class ConfigUpdater
implements IConfigUpdater {
    private static final String SAVE_ERROR = "Error while saving the configuration file.";
    protected final File configFile;
    protected final FileConfiguration config;
    protected final File playerInterfaceFile;
    protected final FileConfiguration playerInterface;

    protected ConfigUpdater(ODailyQuests plugin) {
        FilesManager filesManager = plugin.getFilesManager();
        this.configFile = filesManager.getConfigurationFile().getFile();
        this.config = filesManager.getConfigurationFile().getConfig();
        this.playerInterfaceFile = filesManager.getPlayerInterfaceFile().getFile();
        this.playerInterface = filesManager.getPlayerInterfaceFile().getConfig();
    }

    protected void setDefaultConfigItem(String path, Object value, FileConfiguration fileConfiguration, File file, boolean replace) {
        if (fileConfiguration.contains(path) && !replace) {
            return;
        }
        fileConfiguration.set(path, value);
        try {
            fileConfiguration.save(file);
            if (replace) {
                PluginLogger.warn("Parameter \"" + path + "\" was replaced in one of your configuration files.");
            } else {
                PluginLogger.warn("Parameter \"" + path + "\" was missing in one of your configuration files. It has been added automatically.");
            }
        }
        catch (IOException e) {
            PluginLogger.error(SAVE_ERROR);
        }
    }

    protected void removeConfigItem(String path, FileConfiguration fileConfiguration, File file) {
        if (!fileConfiguration.contains(path)) {
            return;
        }
        fileConfiguration.set(path, null);
        try {
            fileConfiguration.save(file);
            PluginLogger.warn("Parameter \"" + path + "\" was removed from one of your configuration files.");
        }
        catch (IOException e) {
            PluginLogger.error(SAVE_ERROR);
        }
    }

    protected void parameterReplaced(String oldParameter, String newParameter) {
        PluginLogger.warn("The parameter \"" + oldParameter + "\" has been replaced by \"" + newParameter + "\" in the configuration file.");
        PluginLogger.warn("If applicable, its old value has been automatically converted. Please refer to the changelog for more information.");
    }

    protected void updateVersion(String version) {
        this.config.set("version", (Object)version);
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            PluginLogger.error(SAVE_ERROR);
        }
    }
}

