/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools.updater.database;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.updater.database.IDatabaseUpdater;
import com.ordwen.odailyquests.tools.updater.database.updates.Update0to1;
import com.ordwen.odailyquests.tools.updater.database.updates.Update1to2;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public class DatabaseUpdateManager {
    private final ODailyQuests plugin;
    private final Map<String, IDatabaseUpdater> updaters = new LinkedHashMap<String, IDatabaseUpdater>();

    public DatabaseUpdateManager(ODailyQuests plugin) {
        this.plugin = plugin;
        this.updaters.put("1", new Update0to1(plugin));
        this.updaters.put("2", new Update1to2(plugin));
    }

    public void runUpdates() {
        FileConfiguration configFile = this.plugin.getFilesManager().getConfigurationFile().getConfig();
        String currentVersion = configFile.getString("database_version", "0");
        for (Map.Entry<String, IDatabaseUpdater> entry : this.updaters.entrySet()) {
            String updateVersion = entry.getKey();
            IDatabaseUpdater updater = entry.getValue();
            if (Integer.parseInt(currentVersion) >= Integer.parseInt(updateVersion)) continue;
            PluginLogger.warn("Applying database update: " + updateVersion);
            updater.apply(this.plugin, updateVersion);
        }
    }
}

