/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools.updater.database;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.files.FilesManager;
import com.ordwen.odailyquests.files.implementations.ProgressionFile;
import com.ordwen.odailyquests.quests.player.progression.storage.DatabaseManager;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.updater.database.IDatabaseUpdater;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class DatabaseUpdater
implements IDatabaseUpdater {
    protected final File configFile;
    protected final FileConfiguration config;
    protected final DatabaseManager databaseManager;
    protected final ProgressionFile progressionFile;

    protected DatabaseUpdater(ODailyQuests plugin) {
        FilesManager filesManager = plugin.getFilesManager();
        this.configFile = filesManager.getConfigurationFile().getFile();
        this.config = filesManager.getConfigurationFile().getConfig();
        this.databaseManager = plugin.getDatabaseManager();
        this.progressionFile = filesManager.getProgressionFile();
    }

    protected void updateVersion(String version) {
        this.config.set("database_version", (Object)version);
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            PluginLogger.error("Error while saving the configuration file.");
        }
    }
}

