/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools.updater.database.updates;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Database;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.enums.SQLQuery;
import com.ordwen.odailyquests.enums.StorageMode;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.updater.database.DatabaseUpdater;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class Update0to1
extends DatabaseUpdater {
    private static final String SELECT_ALL_FROM_PLAYER_TABLE = "    SELECT * FROM `PLAYER`;\n";
    private static final String COUNT_PLAYER_OLD = "    SELECT COUNT(*) FROM `PLAYER`\n";
    private static final String COUNT_PLAYER_NEW = "    SELECT COUNT(*) FROM `odq_player`\n";

    public Update0to1(ODailyQuests plugin) {
        super(plugin);
    }

    @Override
    public void apply(ODailyQuests plugin, String version) {
        if (Database.getMode() == StorageMode.SQLITE || Database.getMode() == StorageMode.MYSQL) {
            this.applyMySQL();
        } else if (Database.getMode() == StorageMode.YAML) {
            this.applyYAML();
        } else {
            PluginLogger.info("No database update required for storage mode: " + String.valueOf((Object)Database.getMode()));
        }
        this.updateVersion(version);
    }

    @Override
    public void applyMySQL() {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        Debugger.write("Starting SQL data conversion...");
        StorageMode currentMode = Database.getMode();
        try {
            Class.forName("org.h2.Driver");
            Debugger.write("H2 driver loaded successfully.");
        }
        catch (ClassNotFoundException e) {
            PluginLogger.error("Failed to load H2 driver.");
            PluginLogger.error(e.getMessage());
        }
        int oldPlayerCount = 0;
        try {
            connection = currentMode == StorageMode.SQLITE ? DriverManager.getConnection("jdbc:h2:./plugins/ODailyQuests/database", "odq", "") : this.databaseManager.getSqlManager().getConnection();
            try {
                statement = connection.prepareStatement(COUNT_PLAYER_OLD);
                try {
                    resultSet = statement.executeQuery();
                    try {
                        if (resultSet.next()) {
                            oldPlayerCount = resultSet.getInt(1);
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            PluginLogger.error("An error has occurred while trying to count players in the old SQL table.");
            PluginLogger.error(e.getMessage());
            Debugger.write("An error has occurred while trying to count players in the old SQL table.");
            Debugger.write(e.getMessage());
        }
        try {
            connection = currentMode == StorageMode.SQLITE ? DriverManager.getConnection("jdbc:h2:./plugins/ODailyQuests/database", "odq", "") : this.databaseManager.getSqlManager().getConnection();
            try {
                statement = connection.prepareStatement(SELECT_ALL_FROM_PLAYER_TABLE);
                try {
                    resultSet = statement.executeQuery();
                    try {
                        while (resultSet.next()) {
                            String playerName = resultSet.getString("PLAYERNAME").trim();
                            Debugger.write("Trying to convert data for player " + playerName + ".");
                            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
                            if (!offlinePlayer.hasPlayedBefore()) {
                                Debugger.write("Impossible to find UUID for player " + playerName + ".");
                                continue;
                            }
                            String playerUuid = offlinePlayer.getUniqueId().toString();
                            Debugger.write("Found UUID for player " + playerName + " : " + playerUuid + ".");
                            long timestamp = resultSet.getLong("PLAYERTIMESTAMP");
                            int achievedQuests = resultSet.getInt("ACHIEVEDQUESTS");
                            int totalAchievedQuests = resultSet.getInt("TOTALACHIEVEDQUESTS");
                            this.updateSQLPlayerData(playerName, playerUuid, timestamp, achievedQuests, totalAchievedQuests);
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    Debugger.write("SQL data conversion completed successfully.");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            PluginLogger.error("An error has occurred while trying to convert SQL data.");
            PluginLogger.error(e.getMessage());
            Debugger.write("An error has occurred while trying to convert SQL data.");
            Debugger.write(e.getMessage());
        }
        int newPlayerCount = 0;
        try (Connection connection2 = this.databaseManager.getSqlManager().getConnection();
             PreparedStatement statement2 = connection2.prepareStatement(COUNT_PLAYER_NEW);
             ResultSet resultSet2 = statement2.executeQuery();){
            if (resultSet2.next()) {
                newPlayerCount = resultSet2.getInt(1);
            }
        }
        catch (SQLException e) {
            PluginLogger.error("An error has occurred while trying to count players in the new SQL table.");
            PluginLogger.error(e.getMessage());
            Debugger.write("An error has occurred while trying to count players in the new SQL table.");
            Debugger.write(e.getMessage());
        }
        if (oldPlayerCount == newPlayerCount) {
            Debugger.write("SQL data conversion completed successfully. " + oldPlayerCount + " players have been converted.");
            PluginLogger.warn("SQL data conversion completed successfully. " + oldPlayerCount + " players have been converted.");
        } else {
            Debugger.write("SQL data conversion completed with discrepancies: " + oldPlayerCount + " old players, but only " + newPlayerCount + " new players found.");
            PluginLogger.error("SQL data conversion completed with discrepancies: " + oldPlayerCount + " old players, but only " + newPlayerCount + " new players found.");
        }
    }

    @Override
    public void applySQLite() {
    }

    @Override
    public void applyYAML() {
        FileConfiguration config = this.progressionFile.getConfig();
        Debugger.write("Starting YAML data conversion...");
        for (String playerName : config.getKeys(false)) {
            Debugger.write("Trying to convert data for player " + playerName + ".");
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
            if (!offlinePlayer.hasPlayedBefore()) {
                Debugger.write("Impossible to find UUID for player " + playerName + ". Skipping.");
                continue;
            }
            String playerUuid = offlinePlayer.getUniqueId().toString();
            Debugger.write("Found UUID for player " + playerName + " : " + playerUuid + ".");
            if (config.contains(playerUuid)) {
                Debugger.write("Player " + playerName + " data already exists in the new format. Skipping.");
                continue;
            }
            config.set(playerUuid + ".timestamp", (Object)config.getLong(playerName + ".timestamp"));
            config.set(playerUuid + ".achievedQuests", (Object)config.getInt(playerName + ".achievedQuests"));
            config.set(playerUuid + ".totalAchievedQuests", (Object)config.getInt(playerName + ".totalAchievedQuests"));
            ConfigurationSection oldQuestsSection = config.getConfigurationSection(playerName + ".quests");
            if (oldQuestsSection != null) {
                ConfigurationSection newQuestsSection = config.createSection(playerUuid + ".quests");
                for (String key : oldQuestsSection.getKeys(false)) {
                    ConfigurationSection questSection = oldQuestsSection.getConfigurationSection(key);
                    if (questSection == null) continue;
                    ConfigurationSection newQuestSection = newQuestsSection.createSection(key);
                    newQuestSection.set("index", (Object)questSection.getInt("index"));
                    newQuestSection.set("progression", (Object)questSection.getInt("progression"));
                    newQuestSection.set("requiredAmount", (Object)questSection.getInt("requiredAmount"));
                    newQuestSection.set("isAchieved", (Object)questSection.getBoolean("isAchieved"));
                }
            }
            config.set(playerName, null);
            Debugger.write("Conversion completed for player " + playerName + " -> " + playerUuid);
        }
        try {
            config.save(this.progressionFile.getFile());
            Debugger.write("YAML data conversion completed successfully.");
        }
        catch (IOException e) {
            PluginLogger.error("An error occurred while saving the converted YAML data.");
            PluginLogger.error(e.getMessage());
        }
        Debugger.write("YAML data conversion completed successfully.");
        PluginLogger.warn("YAML data conversion completed successfully.");
    }

    private void updateSQLPlayerData(String playerName, String playerUuid, long timestamp, int achievedQuests, int totalAchievedQuests) {
        try (Connection connection = this.databaseManager.getSqlManager().getConnection();){
            String checkQuery = SQLQuery.LOAD_PLAYER.getQuery();
            try (PreparedStatement checkStatement = connection.prepareStatement(checkQuery);){
                checkStatement.setString(1, playerUuid);
                try (ResultSet resultSet = checkStatement.executeQuery();){
                    if (resultSet.next()) {
                        Debugger.write("Player " + playerUuid + " data already exists in the new schema. Skipping.");
                        return;
                    }
                }
            }
            LinkedHashMap<AbstractQuest, Progression> quests = new LinkedHashMap<AbstractQuest, Progression>();
            PlayerQuests playerQuests = new PlayerQuests(timestamp, quests);
            playerQuests.setAchievedQuests(achievedQuests);
            playerQuests.setTotalAchievedQuests(totalAchievedQuests);
            this.databaseManager.getSqlManager().getSaveProgressionSQL().saveProgression(playerName, playerUuid, playerQuests, true);
            Debugger.write("Player " + playerName + " data saved in the new schema.");
        }
        catch (SQLException e) {
            Debugger.write("An error occurred while saving player " + playerUuid + " data.");
            Debugger.write(e.getMessage());
        }
    }
}

