/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.tools.updater.database.updates;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.Database;
import com.ordwen.odailyquests.enums.StorageMode;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.updater.database.DatabaseUpdater;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class Update1to2
extends DatabaseUpdater {
    public Update1to2(ODailyQuests plugin) {
        super(plugin);
    }

    @Override
    public void apply(ODailyQuests plugin, String version) {
        if (Database.getMode() == StorageMode.YAML) {
            this.applyYAML();
        } else {
            PluginLogger.warn("No database update required for storage mode: " + String.valueOf((Object)Database.getMode()));
        }
        this.updateVersion(version);
    }

    @Override
    public void applyMySQL() {
    }

    @Override
    public void applySQLite() {
    }

    @Override
    public void applyYAML() {
        FileConfiguration config = this.progressionFile.getConfig();
        for (String playerUuid : config.getKeys(false)) {
            ConfigurationSection questsSection;
            ConfigurationSection playerSection = config.getConfigurationSection(playerUuid);
            if (playerSection == null || (questsSection = playerSection.getConfigurationSection("quests")) == null) continue;
            for (String questId : questsSection.getKeys(false)) {
                ConfigurationSection questSection = questsSection.getConfigurationSection(questId);
                if (questSection == null) continue;
                Update1to2.ensurePath(questSection, "requiredAmount", 0);
                Update1to2.ensurePath(questSection, "selectedRequired", -1);
            }
        }
        try {
            config.save(this.progressionFile.getFile());
        }
        catch (Exception e) {
            PluginLogger.error("Failed to apply database update 1 to 2 for YAML: " + e.getMessage());
            return;
        }
        PluginLogger.info("YAML database update 1 to 2 applied successfully.");
    }

    private static void ensurePath(ConfigurationSection section, String path, Object defaultValue) {
        if (!section.contains(path)) {
            section.set(path, defaultValue);
        }
    }
}

