/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.api.commands.player;

import com.ordwen.odailyquests.api.commands.player.PlayerCommandBase;
import com.ordwen.odailyquests.configuration.functionalities.CommandAliases;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlayerCommandRegistry {
    private final Map<String, PlayerCommandBase> handlers = new HashMap<String, PlayerCommandBase>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public void registerCommand(PlayerCommandBase handler) {
        String name = handler.getName().toLowerCase();
        this.handlers.put(name, handler);
        List<String> subAliases = CommandAliases.getSubcommandAliases(name);
        for (String alias : subAliases) {
            this.aliases.put(alias.toLowerCase(), name);
        }
    }

    public PlayerCommandBase getCommandHandler(String name) {
        String key = name.toLowerCase();
        String resolved = this.aliases.getOrDefault(key, key);
        return this.handlers.get(resolved);
    }

    public Collection<PlayerCommandBase> getCommandHandlers() {
        return this.handlers.values();
    }

    public Set<String> getCommandNames() {
        return this.handlers.keySet();
    }
}

