/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin;

import com.ordwen.odailyquests.api.commands.admin.AdminCommandBase;
import com.ordwen.odailyquests.api.commands.admin.AdminCommandRegistry;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AdminCompleter
implements TabCompleter {
    private final AdminCommandRegistry commandRegistry;

    public AdminCompleter(AdminCommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (!sender.hasPermission(QuestsPermissions.QUESTS_ADMIN.get())) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>(this.commandRegistry.getCommandNames());
            subCommands.add("reload");
            return (List)StringUtil.copyPartialMatches((String)args[0], subCommands, new ArrayList());
        }
        AdminCommandBase subCommand = this.commandRegistry.getCommandHandler(args[0]);
        if (subCommand == null) {
            return Collections.emptyList();
        }
        return subCommand.onTabComplete(sender, args);
    }
}

