/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin.handlers;

import com.ordwen.odailyquests.api.commands.admin.AdminCommandBase;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ARerollCommand
extends AdminCommandBase {
    @Override
    public String getName() {
        return "reroll";
    }

    @Override
    public String getPermission() {
        return QuestsPermissions.QUESTS_ADMIN.get();
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (args.length >= 3 && args[1] != null && args[2] != null) {
            Player target = this.getTargetPlayer(sender, args[1]);
            if (target == null) {
                return;
            }
            int index = this.parseQuestIndex(sender, args[2]);
            if (index == -1) {
                return;
            }
            this.reroll(sender, target, index);
        } else {
            this.help(sender);
        }
    }

    private void reroll(CommandSender sender, Player target, int index) {
        PlayerQuests playerQuests;
        String playerName = target.getName();
        Map<String, PlayerQuests> activeQuests = QuestsManager.getActiveQuests();
        if (index < 1 || index > activeQuests.get(playerName).getQuests().size()) {
            this.invalidQuest(sender);
            return;
        }
        if (activeQuests.containsKey(playerName) && (playerQuests = activeQuests.get(playerName)).rerollQuest(index - 1, target)) {
            this.confirmationToSender(sender, index, playerName);
            this.confirmationToTarget(index, target);
        }
    }

    private void confirmationToSender(CommandSender sender, int index, String target) {
        String msg = QuestsMessages.QUEST_REROLLED_ADMIN.toString();
        if (msg != null) {
            sender.sendMessage(msg.replace("%index%", String.valueOf(index)).replace("%target%", target));
        }
    }

    private void confirmationToTarget(int index, Player target) {
        String msg = QuestsMessages.QUEST_REROLLED.toString();
        if (msg != null) {
            target.sendMessage(msg.replace("%index%", String.valueOf(index)));
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 3) {
            ArrayList<String> questNumbers = new ArrayList<String>();
            for (int i = 1; i <= QuestsPerCategory.getTotalQuestsAmount(); ++i) {
                questNumbers.add(String.valueOf(i));
            }
            return questNumbers;
        }
        if (args.length >= 4) {
            return Collections.emptyList();
        }
        return null;
    }
}

