/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin.handlers;

import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.api.commands.admin.AdminCommandBase;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.tools.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AddCommand
extends AdminCommandBase {
    private static final String ADD = "add";

    @Override
    public String getName() {
        return ADD;
    }

    @Override
    public String getPermission() {
        return QuestsPermissions.QUESTS_ADMIN.get();
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (args.length == 4 && args[1].equalsIgnoreCase("total")) {
            String playerName = args[2];
            String amountStr = args[3];
            Pair<Player, Integer> playerAmount = this.getPlayerAndAmount(sender, playerName, amountStr);
            if (playerAmount == null) {
                return;
            }
            Player target = playerAmount.first();
            int amount = playerAmount.second();
            this.addTotalAmount(sender, target, amount);
        } else if (args.length == 5 && args[1].equalsIgnoreCase("total")) {
            String category = args[2];
            String playerName = args[3];
            String amountStr = args[4];
            if (CategoriesLoader.getAllCategories().containsKey(category)) {
                Pair<Player, Integer> playerAmount = this.getPlayerAndAmount(sender, playerName, amountStr);
                if (playerAmount == null) {
                    return;
                }
                Player target = playerAmount.first();
                int amount = playerAmount.second();
                this.addCategoryAmount(sender, target, category, amount);
            } else {
                this.invalidCategory(sender);
            }
        } else {
            this.help(sender);
        }
    }

    private Pair<Player, Integer> getPlayerAndAmount(CommandSender sender, String playerName, String amountStr) {
        int amount;
        Player target = this.getTargetPlayer(sender, playerName);
        if (target == null) {
            return null;
        }
        try {
            amount = Integer.parseInt(amountStr);
        }
        catch (NumberFormatException e) {
            this.invalidAmount(sender);
            return null;
        }
        return new Pair<Player, Integer>(target, amount);
    }

    private void addTotalAmount(CommandSender sender, Player target, int amount) {
        PlayerQuests playerQuests = ODailyQuestsAPI.getPlayerQuests(target.getName());
        playerQuests.addTotalAchievedQuests(amount);
        this.sendAdminTotalMessage(sender, target.getName(), amount);
        this.sendTargetTotalMessage(target, amount);
    }

    private void addCategoryAmount(CommandSender sender, Player target, String category, int amount) {
        PlayerQuests playerQuests = ODailyQuestsAPI.getPlayerQuests(target.getName());
        playerQuests.addTotalCategoryAchievedQuests(category, amount);
        this.sendAdminTotalCategoryMessage(sender, target.getName(), amount, category);
        this.sendTargetTotalCategoryMessage(target, amount, category);
    }

    private void sendAdminTotalMessage(CommandSender sender, String targetName, int amount) {
        String msg = QuestsMessages.ADD_TOTAL_ADMIN.toString();
        if (msg != null) {
            sender.sendMessage(msg.replace("%target%", targetName).replace("%amount%", String.valueOf(amount)));
        }
    }

    private void sendTargetTotalMessage(Player target, int amount) {
        String msg = QuestsMessages.ADD_TOTAL_TARGET.toString();
        if (msg != null) {
            target.sendMessage(msg.replace("%amount%", String.valueOf(amount)));
        }
    }

    private void sendAdminTotalCategoryMessage(CommandSender sender, String targetName, int amount, String context) {
        String msg = QuestsMessages.ADD_TOTAL_CATEGORY_ADMIN.toString();
        if (msg != null) {
            sender.sendMessage(msg.replace("%target%", targetName).replace("%amount%", String.valueOf(amount)).replace("%category%", context));
        }
    }

    private void sendTargetTotalCategoryMessage(Player target, int amount, String category) {
        String msg = QuestsMessages.ADD_TOTAL_CATEGORY_TARGET.toString();
        if (msg != null) {
            target.sendMessage(msg.replace("%amount%", String.valueOf(amount)).replace("%category%", category));
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2 && args[0].equalsIgnoreCase(ADD)) {
            return Collections.singletonList("total");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase(ADD) && args[1].equalsIgnoreCase("total")) {
            Set<String> categories = CategoriesLoader.getAllCategories().keySet();
            ArrayList<String> completions = new ArrayList<String>(categories);
            Bukkit.getOnlinePlayers().forEach(player -> completions.add(player.getName()));
            return completions;
        }
        if (args.length == 4 && args[0].equalsIgnoreCase(ADD) && args[1].equalsIgnoreCase("total") && CategoriesLoader.hasCategory(args[2])) {
            return null;
        }
        return Collections.emptyList();
    }
}

