/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin.handlers;

import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.api.commands.admin.AdminCommandBase;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.QuestLoaderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ResetCommand
extends AdminCommandBase {
    private static final String RESET = "reset";

    @Override
    public String getName() {
        return RESET;
    }

    @Override
    public String getPermission() {
        return QuestsPermissions.QUESTS_ADMIN.get();
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (args.length < 3) {
            this.help(sender);
            return;
        }
        String action = args[1].toLowerCase();
        if (action.equalsIgnoreCase("total")) {
            this.handleResetTotal(sender, args);
        } else if (action.equalsIgnoreCase("quests")) {
            this.handleResetQuests(sender, args);
        } else {
            this.help(sender);
        }
    }

    private void handleResetTotal(CommandSender sender, String[] args) {
        if (args.length == 3) {
            Player target = this.getTargetPlayer(sender, args[2]);
            if (target != null) {
                this.resetTotal(sender, target);
            }
        } else if (args.length == 4) {
            String category = args[2];
            if (!CategoriesLoader.getAllCategories().containsKey(category)) {
                this.invalidCategory(sender);
                return;
            }
            Player target = this.getTargetPlayer(sender, args[3]);
            if (target != null) {
                this.resetCategory(sender, target, category);
            }
        } else {
            this.help(sender);
        }
    }

    private void handleResetQuests(CommandSender sender, String[] args) {
        Player target = this.getTargetPlayer(sender, args[2]);
        if (target != null) {
            this.quests(sender, target);
        }
    }

    public void quests(CommandSender sender, Player target) {
        String playerName = target.getName();
        PlayerQuests playerQuests = QuestsManager.getActiveQuests().get(playerName);
        Map<String, Integer> totalAchievedQuestsByCategory = playerQuests.getTotalAchievedQuestsByCategory();
        int totalAchievedQuests = playerQuests.getTotalAchievedQuests();
        QuestLoaderUtils.loadNewPlayerQuests(playerName, QuestsManager.getActiveQuests(), totalAchievedQuestsByCategory, totalAchievedQuests);
        String msg = QuestsMessages.QUESTS_RENEWED_ADMIN.toString();
        if (msg != null) {
            sender.sendMessage(msg.replace("%target%", target.getName()));
        }
    }

    private void resetTotal(CommandSender sender, Player target) {
        PlayerQuests playerQuests = ODailyQuestsAPI.getPlayerQuests(target.getName());
        playerQuests.setTotalAchievedQuests(0);
        String msg = QuestsMessages.TOTAL_AMOUNT_RESET_ADMIN.toString();
        if (msg != null) {
            sender.sendMessage(msg.replace("%target%", target.getName()));
        }
        if ((msg = QuestsMessages.TOTAL_AMOUNT_RESET.getMessage(target)) != null) {
            target.sendMessage(msg);
        }
    }

    private void resetCategory(CommandSender sender, Player target, String category) {
        PlayerQuests playerQuests = ODailyQuestsAPI.getPlayerQuests(target.getName());
        playerQuests.setTotalCategoryAchievedQuests(category, 0);
        String msg = QuestsMessages.TOTAL_CATEGORY_RESET_ADMIN.toString();
        if (msg != null) {
            sender.sendMessage(msg.replace("%target%", target.getName()).replace("%category%", category));
        }
        if ((msg = QuestsMessages.TOTAL_CATEGORY_RESET_TARGET.getMessage(target)) != null) {
            target.sendMessage(msg.replace("%category%", category));
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2 && args[0].equalsIgnoreCase(RESET)) {
            return List.of("quests", "total");
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("total")) {
            Set<String> categories = CategoriesLoader.getAllCategories().keySet();
            ArrayList<String> suggestions = new ArrayList<String>(categories);
            Bukkit.getOnlinePlayers().forEach(p -> suggestions.add(p.getName()));
            return suggestions;
        }
        if (args.length == 4 && args[1].equalsIgnoreCase("total") && CategoriesLoader.getAllCategories().containsKey(args[2])) {
            return null;
        }
        if (args.length >= 4) {
            return Collections.emptyList();
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("quests")) {
            return null;
        }
        return Collections.emptyList();
    }
}

