/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin.handlers;

import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.api.commands.admin.AdminCommandBase;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.categories.Category;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SetCommand
extends AdminCommandBase {
    private static final String SET = "set";
    private static final String SLOT = "%slot%";
    private static final String QUEST = "%quest%";
    private static final String QUEST_ID = "%quest_id%";

    @Override
    public String getName() {
        return SET;
    }

    @Override
    public String getPermission() {
        return QuestsPermissions.QUESTS_ADMIN.get();
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (args.length < 5) {
            this.help(sender);
            return;
        }
        Player target = this.getTargetPlayer(sender, args[1]);
        if (target == null) {
            return;
        }
        PlayerQuests playerQuests = ODailyQuestsAPI.getPlayerQuests(target.getName());
        if (playerQuests == null) {
            String msg = QuestsMessages.PLAYER_QUESTS_NOT_LOADED.toString();
            if (msg != null) {
                sender.sendMessage(msg);
            }
            return;
        }
        int slotIndex = this.parseQuestIndex(sender, args[2]);
        if (slotIndex == -1) {
            return;
        }
        if (slotIndex < 1 || slotIndex > playerQuests.getQuests().size()) {
            this.invalidQuest(sender);
            return;
        }
        String categoryName = args[3];
        if (!CategoriesLoader.hasCategory(categoryName)) {
            this.invalidCategory(sender);
            return;
        }
        String questId = args[4];
        Category category = CategoriesLoader.getCategoryByName(categoryName);
        Optional<AbstractQuest> questOptional = this.findQuest(category, questId);
        if (questOptional.isEmpty()) {
            this.invalidQuestId(sender);
            return;
        }
        AbstractQuest questToAssign = questOptional.get();
        PlayerQuests.ReplaceResult replaceResult = playerQuests.setQuestAtIndex(slotIndex - 1, questToAssign);
        switch (replaceResult) {
            case SUCCESS: {
                this.confirmationToSender(sender, target.getName(), questToAssign, questId, slotIndex, categoryName);
                this.confirmationToTarget(target, questToAssign, questId, slotIndex, categoryName);
                break;
            }
            case INVALID_INDEX: {
                this.invalidQuest(sender);
                break;
            }
            case ALREADY_PRESENT: {
                String msg = QuestsMessages.QUEST_ALREADY_ASSIGNED.toString();
                if (msg == null) break;
                sender.sendMessage(msg.replace(QUEST, questToAssign.getQuestName()));
            }
        }
    }

    private Optional<AbstractQuest> findQuest(Category category, String questId) {
        if (category == null) {
            return Optional.empty();
        }
        return category.stream().filter(quest -> quest.getFileIndex().equals(questId)).findFirst();
    }

    private void confirmationToSender(CommandSender sender, String targetName, AbstractQuest quest, String questId, int slotIndex, String categoryName) {
        String msg = QuestsMessages.QUEST_SET_ADMIN.toString();
        if (msg != null) {
            sender.sendMessage(msg.replace("%target%", targetName).replace(SLOT, String.valueOf(slotIndex)).replace("%category%", categoryName).replace(QUEST_ID, String.valueOf(questId)).replace(QUEST, quest.getQuestName()));
        }
    }

    private void confirmationToTarget(Player target, AbstractQuest quest, String questId, int slotIndex, String categoryName) {
        String msg = QuestsMessages.QUEST_SET_TARGET.toString();
        if (msg != null) {
            target.sendMessage(msg.replace(SLOT, String.valueOf(slotIndex)).replace("%category%", categoryName).replace(QUEST_ID, String.valueOf(questId)).replace(QUEST, quest.getQuestName()));
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] args) {
        return switch (args.length) {
            case 2 -> this.getOnlinePlayerNames();
            case 3 -> this.getQuestNumbers(args[1]);
            case 4 -> this.getCategoryNames();
            case 5 -> this.getQuestIds(args[3]);
            default -> args.length >= 6 ? Collections.emptyList() : null;
        };
    }

    private List<String> getOnlinePlayerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            names.add(p.getName());
        }
        return names;
    }

    private List<String> getQuestNumbers(String playerName) {
        PlayerQuests pq;
        Player target = Bukkit.getPlayerExact((String)playerName);
        PlayerQuests playerQuests = pq = target != null ? ODailyQuestsAPI.getPlayerQuests(target.getName()) : null;
        if (pq == null) {
            return Collections.emptyList();
        }
        int size = pq.getQuests().size();
        ArrayList<String> numbers = new ArrayList<String>(size);
        for (int i = 1; i <= size; ++i) {
            numbers.add(String.valueOf(i));
        }
        return numbers;
    }

    private List<String> getCategoryNames() {
        return new ArrayList<String>(CategoriesLoader.getAllCategories().keySet());
    }

    private List<String> getQuestIds(String categoryName) {
        if (!CategoriesLoader.hasCategory(categoryName)) {
            return Collections.emptyList();
        }
        Category category = CategoriesLoader.getCategoryByName(categoryName);
        if (category == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        category.forEach(q -> ids.add(q.getFileIndex()));
        return ids;
    }
}

