/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.interfaces.playerinterface;

import com.ordwen.odailyquests.commands.interfaces.playerinterface.items.ItemType;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.items.PlayerHead;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.items.getters.InterfaceItemGetter;
import com.ordwen.odailyquests.configuration.functionalities.CompleteOnlyOnClick;
import com.ordwen.odailyquests.configuration.functionalities.progression.ProgressBar;
import com.ordwen.odailyquests.files.implementations.PlayerInterfaceFile;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.QuestLoaderUtils;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.DisplayName;
import com.ordwen.odailyquests.tools.ItemUtils;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import com.ordwen.odailyquests.tools.TimeRemain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class PlayerQuestsInterface
extends InterfaceItemGetter {
    private static final String ERROR_OCCURRED = "An error occurred when loading the player interface. ";
    private static final String OUT_OF_BOUNDS = " is out of bounds (slots must be between 1 and defined size).";
    private static final String PROGRESS = "%progress%";
    private static final String PROGRESS_BAR = "%progressBar%";
    private static final String REQUIRED = "%required%";
    private static final String DISPLAY_NAME = "%displayName%";
    private static final String ACHIEVED = "%achieved%";
    private static final String DRAW_IN = "%drawIn%";
    private static final String STATUS = "%status%";
    private static final String MATERIAL = "material";
    private final PlayerInterfaceFile playerInterfaceFile;
    private final PlayerHead playerHead;
    private final Map<Integer, List<Integer>> slotQuests = new HashMap<Integer, List<Integer>>();
    private final Set<ItemStack> fillItems = new HashSet<ItemStack>();
    private final Set<ItemStack> closeItems = new HashSet<ItemStack>();
    private final Map<Integer, List<String>> playerCommandsItems = new HashMap<Integer, List<String>>();
    private final Map<Integer, List<String>> consoleCommandsItems = new HashMap<Integer, List<String>>();
    private final Map<Integer, ItemStack> papiItems = new HashMap<Integer, ItemStack>();
    private String interfaceName;
    private Inventory playerQuestsInventoryBase;
    private int size;
    private String achievedStr;
    private String statusStr;
    private String progressStr;
    private String completeGetTypeStr;
    private boolean isGlowingEnabled;
    private boolean isStatusDisabled;

    public PlayerQuestsInterface(PlayerInterfaceFile playerInterfaceFile) {
        this.playerInterfaceFile = playerInterfaceFile;
        this.playerHead = new PlayerHead(playerInterfaceFile);
    }

    public void load() {
        ConfigurationSection section = this.playerInterfaceFile.getConfig().getConfigurationSection("player_interface");
        if (section == null) {
            PluginLogger.error("An error occurred when loading the player interface. The playerInterface file is not correctly configured.");
            return;
        }
        this.loadVariables(section);
        ConfigurationSection questsSection = section.getConfigurationSection("quests");
        if (questsSection == null) {
            PluginLogger.error("An error occurred when loading the player interface. The quests section is not defined in the playerInterface file.");
            return;
        }
        this.loadQuestsSlots(questsSection);
        ConfigurationSection itemsSection = section.getConfigurationSection("items");
        if (itemsSection == null) {
            PluginLogger.warn("The items section is not defined in the playerInterface file.");
            return;
        }
        this.loadItems(itemsSection);
        PluginLogger.fine("Player quests interface successfully loaded.");
    }

    private void loadVariables(ConfigurationSection interfaceConfig) {
        this.slotQuests.clear();
        this.fillItems.clear();
        this.closeItems.clear();
        this.playerCommandsItems.clear();
        this.consoleCommandsItems.clear();
        this.papiItems.clear();
        this.playerHead.load();
        this.interfaceName = TextFormatter.format(interfaceConfig.getString(".inventory_name"));
        this.isGlowingEnabled = interfaceConfig.getBoolean("glowing_if_achieved");
        this.isStatusDisabled = interfaceConfig.getBoolean("disable_status");
        this.size = interfaceConfig.getInt(".size");
        this.playerQuestsInventoryBase = Bukkit.createInventory(null, (int)this.size, (String)"BASIC");
        this.achievedStr = interfaceConfig.getString(".achieved");
        this.statusStr = interfaceConfig.getString(".status");
        this.progressStr = interfaceConfig.getString(".progress");
        this.completeGetTypeStr = interfaceConfig.getString(".complete_get_type");
    }

    private void loadQuestsSlots(ConfigurationSection questsSection) {
        for (String index : questsSection.getKeys(false)) {
            int slot = Integer.parseInt(index) - 1;
            if (questsSection.isList(index)) {
                List values = questsSection.getIntegerList(index);
                this.slotQuests.put(slot, values);
                continue;
            }
            int value = questsSection.getInt(index);
            this.slotQuests.put(slot, Collections.singletonList(value));
        }
    }

    private void loadItems(ConfigurationSection itemsSection) {
        for (String element : itemsSection.getKeys(false)) {
            ConfigurationSection elementSection = itemsSection.getConfigurationSection(element);
            if (elementSection == null) {
                this.configurationError(element, "item", "The item is not defined.");
                continue;
            }
            ConfigurationSection itemSection = elementSection.getConfigurationSection("item");
            if (itemSection == null) {
                this.configurationError(element, "item", "The item is not defined.");
                continue;
            }
            String material = itemSection.getString(MATERIAL);
            if (material == null) {
                this.configurationError(element, MATERIAL, "The material of the item is not defined.");
                continue;
            }
            ItemStack item = this.getItemStack(element, material, itemSection);
            List<Integer> slots = PlayerQuestsInterface.getSlots(itemSection);
            List<ItemFlag> flags = this.getItemFlags(element, itemSection);
            if (flags == null) continue;
            this.loadItemType(elementSection, item, itemSection, slots, flags);
            this.loadPlaceholderItem(slots, item);
            this.addIntoBaseInventory(element, slots, item);
        }
    }

    private static List<Integer> getSlots(ConfigurationSection itemSection) {
        List<Integer> slots = itemSection.isList("slot") ? itemSection.getIntegerList("slot") : List.of(Integer.valueOf(itemSection.getInt("slot")));
        return slots;
    }

    @Nullable
    private List<ItemFlag> getItemFlags(String element, ConfigurationSection itemSection) {
        if (!itemSection.isList("flags")) {
            return Collections.emptyList();
        }
        List rawFlags = itemSection.getStringList("flags");
        ArrayList<ItemFlag> flags = new ArrayList<ItemFlag>(rawFlags.size());
        for (String f : rawFlags) {
            if (f == null) continue;
            String normalized = f.trim().toUpperCase();
            try {
                flags.add(ItemFlag.valueOf((String)normalized));
            }
            catch (IllegalArgumentException ex) {
                this.configurationError(element, "item.flags", normalized + " is not a valid ItemFlag.");
                return null;
            }
        }
        return flags;
    }

    private ItemStack getItemStack(String element, String material, ConfigurationSection itemSection) {
        ItemStack item;
        if (material.equals("CUSTOM_HEAD")) {
            String texture = itemSection.getString("texture");
            item = ItemUtils.getCustomHead(texture);
        } else {
            item = material.contains(":") ? this.getItem(material, element, MATERIAL) : new ItemStack(Material.valueOf((String)material));
        }
        if (item == null) {
            item = new ItemStack(Material.BARRIER);
        }
        return item;
    }

    private void addIntoBaseInventory(String element, List<Integer> slots, ItemStack item) {
        for (int slot : slots) {
            if (slot > 0 && slot <= this.size) {
                this.playerQuestsInventoryBase.setItem(slot - 1, item);
                continue;
            }
            PluginLogger.error("An error occurred when loading the player interface. The slot defined for the item " + element + OUT_OF_BOUNDS);
        }
    }

    private void loadPlaceholderItem(List<Integer> slots, ItemStack item) {
        boolean hasPlaceholders = false;
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName() && this.containsPlaceholder(meta.getDisplayName())) {
                hasPlaceholders = true;
            }
            if (!hasPlaceholders && meta.hasLore()) {
                for (String line : meta.getLore()) {
                    if (!this.containsPlaceholder(line)) continue;
                    hasPlaceholders = true;
                    break;
                }
            }
        }
        if (hasPlaceholders) {
            slots.forEach(slot -> this.papiItems.put(slot - 1, item));
        }
    }

    private boolean containsPlaceholder(String text) {
        if (text == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("%\\w+%");
        return pattern.matcher(text).find();
    }

    private void loadItemType(ConfigurationSection elementSection, ItemStack item, ConfigurationSection itemSection, List<Integer> slots, List<ItemFlag> flags) {
        String itemType = elementSection.getString("type");
        switch (ItemType.valueOf(itemType)) {
            case FILL: {
                ItemMeta fillItemMeta = item.getItemMeta();
                if (fillItemMeta == null) {
                    return;
                }
                fillItemMeta.setDisplayName(String.valueOf(ChatColor.RESET));
                if (!flags.isEmpty()) {
                    fillItemMeta.addItemFlags(flags.toArray(new ItemFlag[0]));
                }
                item.setItemMeta(fillItemMeta);
                this.fillItems.add(item);
                break;
            }
            case CLOSE: {
                item.setItemMeta(this.getItemMeta(item, itemSection, flags));
                this.closeItems.add(item);
                break;
            }
            case PLAYER_COMMAND: {
                List commands = elementSection.getStringList("commands");
                item.setItemMeta(this.getItemMeta(item, itemSection, flags));
                for (int slot : slots) {
                    this.playerCommandsItems.put(slot - 1, commands);
                }
                break;
            }
            case CONSOLE_COMMAND: {
                List commands = elementSection.getStringList("commands");
                item.setItemMeta(this.getItemMeta(item, itemSection, flags));
                for (int slot : slots) {
                    this.consoleCommandsItems.put(slot - 1, commands);
                }
                break;
            }
        }
    }

    public Inventory getPlayerQuestsInterface(Player player) {
        Map<String, PlayerQuests> activeQuests = QuestsManager.getActiveQuests();
        if (!activeQuests.containsKey(player.getName())) {
            PluginLogger.error("Impossible to find the player " + player.getName() + " in the active quests.");
            PluginLogger.error("It can happen if the player try to open the interface while the server/plugin is reloading.");
            PluginLogger.error("If the problem persist, please contact the developer.");
            return null;
        }
        PlayerQuests playerQuests = activeQuests.get(player.getName());
        if (QuestLoaderUtils.isTimeToRenew(player, activeQuests)) {
            return this.getPlayerQuestsInterface(player);
        }
        Map<AbstractQuest, Progression> questsMap = playerQuests.getQuests();
        Inventory playerQuestsInventoryIndividual = Bukkit.createInventory(null, (int)this.size, (String)TextFormatter.format(player, this.interfaceName));
        playerQuestsInventoryIndividual.setContents(this.playerQuestsInventoryBase.getContents());
        if (!this.papiItems.isEmpty()) {
            this.applyPapiItems(player, playerQuests, playerQuestsInventoryIndividual);
        }
        playerQuestsInventoryIndividual.setContents(this.playerHead.setPlayerHead(playerQuestsInventoryIndividual, player, this.size).getContents());
        this.applyQuestsItems(player, questsMap, playerQuests, playerQuestsInventoryIndividual);
        return playerQuestsInventoryIndividual;
    }

    private void applyQuestsItems(Player player, Map<AbstractQuest, Progression> questsMap, PlayerQuests playerQuests, Inventory inventory) {
        int i = 0;
        for (Map.Entry<AbstractQuest, Progression> entry : questsMap.entrySet()) {
            Progression playerProgression;
            AbstractQuest quest = entry.getKey();
            ItemStack itemStack = this.getQuestItem(quest, playerProgression = entry.getValue());
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta == null) continue;
            this.configureItemMeta(itemMeta, quest, playerProgression, player, playerQuests);
            itemStack.setItemMeta(itemMeta);
            int menuItemAmount = quest.getMenuItemAmount();
            if (menuItemAmount == 0) {
                itemStack.setAmount(playerProgression.getRequiredAmount());
            } else {
                itemStack.setAmount(menuItemAmount);
            }
            this.placeItemInInventory(i, itemStack, inventory);
            ++i;
        }
    }

    private ItemStack getQuestItem(AbstractQuest quest, Progression playerProgression) {
        return playerProgression.isAchieved() ? quest.getAchievedItem().clone() : quest.getMenuItem().clone();
    }

    private void configureItemMeta(ItemMeta itemMeta, AbstractQuest quest, Progression progression, Player player, PlayerQuests playerQuests) {
        String displayName = TextFormatter.format(player, quest.getQuestName()).replace(REQUIRED, String.valueOf(progression.getRequiredAmount())).replace(DISPLAY_NAME, DisplayName.getDisplayName(quest, progression.getSelectedRequiredIndex()));
        itemMeta.setDisplayName(displayName);
        List<String> lore = this.generateLore(quest, progression, player, playerQuests);
        itemMeta.setLore(lore);
        if (progression.isAchieved() && this.isGlowingEnabled) {
            itemMeta.addEnchant(Enchantment.SILK_TOUCH, 1, false);
        }
        itemMeta.addAttributeModifier(Attribute.GENERIC_MAX_HEALTH, new AttributeModifier(UUID.randomUUID(), "dummy", 0.0, AttributeModifier.Operation.ADD_NUMBER));
        itemMeta.addItemFlags(ItemFlag.values());
    }

    private List<String> generateLore(AbstractQuest quest, Progression playerProgression, Player player, PlayerQuests playerQuests) {
        String hint;
        ArrayList<String> lore = new ArrayList<String>(quest.getQuestDesc());
        String progress = String.valueOf(playerProgression.getAdvancement());
        String progressBar = ProgressBar.getProgressBar(playerProgression.getAdvancement(), playerProgression.getRequiredAmount());
        String required = String.valueOf(playerProgression.getRequiredAmount());
        String achieved = String.valueOf(playerQuests.getAchievedQuests());
        String drawIn = TimeRemain.timeRemain(player.getName());
        String selected = DisplayName.getDisplayName(quest, playerProgression.getSelectedRequiredIndex());
        String status = this.getQuestStatus(playerProgression, player);
        ListIterator<String> it = lore.listIterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            String formatted = str.replace(PROGRESS, progress).replace(PROGRESS_BAR, progressBar).replace(REQUIRED, required).replace(ACHIEVED, achieved).replace(DRAW_IN, drawIn).replace(DISPLAY_NAME, selected).replace(STATUS, status);
            formatted = TextFormatter.format(player, formatted);
            it.set(formatted);
        }
        if (!this.statusStr.isEmpty() && !this.isStatusDisabled) {
            lore.add(TextFormatter.format(TextFormatter.format(player, this.statusStr)));
        }
        if (playerProgression.isAchieved() && !this.achievedStr.isEmpty() && !this.isStatusDisabled) {
            lore.add(TextFormatter.format(this.achievedStr));
        } else if (!this.progressStr.isEmpty() && !this.isStatusDisabled) {
            lore.add(TextFormatter.format(TextFormatter.format(player, this.progressStr).replace(PROGRESS, progress).replace(REQUIRED, required).replace(PROGRESS_BAR, progressBar)));
        }
        if (this.shouldDisplayManualCompletionHint(playerProgression) && (hint = this.getCompleteGetTypeStr()) != null && !hint.isEmpty()) {
            lore.add(TextFormatter.format(player, hint));
        }
        return lore;
    }

    private void placeItemInInventory(int questIndex, ItemStack itemStack, Inventory inventory) {
        List<Integer> slots = this.slotQuests.get(questIndex);
        if (slots == null) {
            PluginLogger.error("An error occurred when loading the player interface. Slot not defined for quest " + (questIndex + 1));
            return;
        }
        for (int slot : slots) {
            if (slot > 0 && slot <= this.size) {
                inventory.setItem(slot - 1, itemStack);
                continue;
            }
            PluginLogger.error("An error occurred when loading the player interface. Slot " + slot + " for quest " + (questIndex + 1) + OUT_OF_BOUNDS);
        }
    }

    private void applyPapiItems(Player player, PlayerQuests playerQuests, Inventory inventory) {
        for (Map.Entry<Integer, ItemStack> entry : this.papiItems.entrySet()) {
            Integer slot = entry.getKey();
            ItemStack itemCopy = entry.getValue().clone();
            if (slot < 0 || slot >= this.size) {
                PluginLogger.error("An error occurred when loading the player interface. An item with placeholders defined for slot " + (slot + 1) + OUT_OF_BOUNDS);
                continue;
            }
            ItemMeta meta = itemCopy.getItemMeta();
            if (meta == null) continue;
            meta.setDisplayName(TextFormatter.format(player, meta.getDisplayName()));
            List lore = meta.getLore();
            if (lore != null) {
                for (String str : lore) {
                    lore.set(lore.indexOf(str), TextFormatter.format(player, str).replace(ACHIEVED, String.valueOf(playerQuests.getAchievedQuests())).replace(DRAW_IN, TimeRemain.timeRemain(player.getName())));
                }
            }
            meta.setLore(lore);
            itemCopy.setItemMeta(meta);
            inventory.setItem(slot.intValue(), itemCopy);
        }
    }

    private ItemMeta getItemMeta(ItemStack itemStack, ConfigurationSection section, List<ItemFlag> flags) {
        String name;
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        if (section.contains("custom_model_data")) {
            meta.setCustomModelData(Integer.valueOf(section.getInt("custom_model_data")));
        }
        if ((name = section.getString("name")) != null) {
            meta.setDisplayName(TextFormatter.format(name));
        }
        List lore = section.getStringList("lore");
        for (String str : lore) {
            lore.set(lore.indexOf(str), TextFormatter.format(str));
        }
        meta.setLore(lore);
        if (flags != null && !flags.isEmpty()) {
            meta.addItemFlags(flags.toArray(new ItemFlag[0]));
        }
        return meta;
    }

    private String getQuestStatus(Progression progression, Player player) {
        if (progression.isAchieved()) {
            return TextFormatter.format(player, this.getAchievedStr());
        }
        if (this.shouldDisplayManualCompletionHint(progression)) {
            String hint = this.getCompleteGetTypeStr();
            if (hint == null || hint.isEmpty()) {
                return TextFormatter.format(player, this.getProgressStr().replace(PROGRESS, String.valueOf(progression.getAdvancement())).replace(REQUIRED, String.valueOf(progression.getRequiredAmount())).replace(PROGRESS_BAR, ProgressBar.getProgressBar(progression.getAdvancement(), progression.getRequiredAmount())));
            }
            return TextFormatter.format(player, hint);
        }
        return TextFormatter.format(player, this.getProgressStr().replace(PROGRESS, String.valueOf(progression.getAdvancement())).replace(REQUIRED, String.valueOf(progression.getRequiredAmount())).replace(PROGRESS_BAR, ProgressBar.getProgressBar(progression.getAdvancement(), progression.getRequiredAmount())));
    }

    private boolean shouldDisplayManualCompletionHint(Progression progression) {
        return CompleteOnlyOnClick.isEnabled() && !progression.isAchieved() && progression.getAdvancement() >= progression.getRequiredAmount();
    }

    public String getInterfaceName(Player player) {
        return TextFormatter.format(player, this.interfaceName);
    }

    public boolean isFillItem(ItemStack itemStack) {
        return this.fillItems.contains(itemStack);
    }

    public boolean isCloseItem(ItemStack itemStack) {
        return this.closeItems.contains(itemStack);
    }

    public boolean isPlayerCommandItem(int slot) {
        return this.playerCommandsItems.containsKey(slot);
    }

    public boolean isConsoleCommandItem(int slot) {
        return this.consoleCommandsItems.containsKey(slot);
    }

    public List<String> getPlayerCommands(int slot) {
        return this.playerCommandsItems.get(slot);
    }

    public List<String> getConsoleCommands(int slot) {
        return this.consoleCommandsItems.get(slot);
    }

    public String getAchievedStr() {
        return this.achievedStr;
    }

    public String getProgressStr() {
        return this.progressStr;
    }

    public String getCompleteGetTypeStr() {
        return this.completeGetTypeStr;
    }
}

