/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.interfaces.playerinterface.items;

import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.ItemUtils;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Buttons {
    private final ConfigurationFile configurationFile;
    private ItemStack previous;
    private ItemStack next;

    public Buttons(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    public void initItems() {
        ConfigurationSection section = this.configurationFile.getConfig().getConfigurationSection("interfaces");
        if (section == null) {
            PluginLogger.warn("Impossible to load buttons because the interfaces section is missing in the configuration file.");
            return;
        }
        this.initPreviousButton(section);
        this.initNextButton(section);
    }

    private void initPreviousButton(ConfigurationSection section) {
        this.previous = ItemUtils.getCustomHead("a2f0425d64fdc8992928d608109810c1251fe243d60d175bed427c651cbe");
        ItemMeta previousMeta = this.previous.getItemMeta();
        if (previousMeta == null) {
            return;
        }
        previousMeta.setDisplayName(TextFormatter.format(section.getString(".previous_item_name")));
        this.previous.setItemMeta(previousMeta);
    }

    private void initNextButton(ConfigurationSection section) {
        this.next = ItemUtils.getCustomHead("6d865aae2746a9b8e9a4fe629fb08d18d0a9251e5ccbe5fa7051f53eab9b94");
        ItemMeta nextMeta = this.next.getItemMeta();
        if (nextMeta == null) {
            return;
        }
        nextMeta.setDisplayName(TextFormatter.format(section.getString(".next_item_name")));
        this.next.setItemMeta(nextMeta);
    }

    public ItemStack getPreviousButton() {
        return this.previous;
    }

    public ItemStack getNextButton() {
        return this.next;
    }
}

