/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.interfaces.playerinterface.items;

import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.items.getters.InterfaceItemGetter;
import com.ordwen.odailyquests.files.implementations.PlayerInterfaceFile;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import com.ordwen.odailyquests.tools.TimeRemain;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class PlayerHead
extends InterfaceItemGetter {
    private static final String SLOT_PARAMETER = "slot";
    private final PlayerInterfaceFile playerInterfaceFile;
    private boolean enabled;
    private final Set<Integer> slots = new HashSet<Integer>();
    private ItemStack head;
    private SkullMeta meta;

    public PlayerHead(PlayerInterfaceFile playerInterfaceFile) {
        this.playerInterfaceFile = playerInterfaceFile;
    }

    public void load() {
        ConfigurationSection section = this.playerInterfaceFile.getConfig().getConfigurationSection("player_interface.player_head");
        if (section == null) {
            PluginLogger.error("Player head section not found in the player interface file.");
            this.enabled = false;
            return;
        }
        this.enabled = section.getBoolean(".enabled");
        if (!this.enabled) {
            return;
        }
        if (section.isString(".material")) {
            String material = section.getString(".material");
            this.head = this.getItem(material, "player_head", ".material");
        }
        if (this.head == null) {
            this.head = new ItemStack(Material.PLAYER_HEAD, 1);
        }
        this.meta = (SkullMeta)this.head.getItemMeta();
        if (this.meta == null) {
            return;
        }
        this.meta.setDisplayName(TextFormatter.format(section.getString(".item_name")));
        this.meta.setLore(section.getStringList(".item_description"));
        if (section.isInt(".custom_model_data")) {
            this.meta.setCustomModelData(Integer.valueOf(section.getInt(".custom_model_data")));
        }
        this.slots.clear();
        if (section.isList(SLOT_PARAMETER)) {
            this.slots.addAll(section.getIntegerList(SLOT_PARAMETER));
        } else {
            this.slots.add(section.getInt(SLOT_PARAMETER) - 1);
        }
    }

    public Inventory setPlayerHead(Inventory inventory, Player player, int size) {
        if (!this.enabled) {
            return inventory;
        }
        for (int slot : this.slots) {
            if (slot >= 0 && slot <= size) {
                inventory.setItem(slot, this.getPlayerHead(player));
                continue;
            }
            PluginLogger.error("An error occurred when loading the player interface.");
            PluginLogger.error("The slot defined for the player head is out of bounds.");
        }
        return inventory;
    }

    public ItemStack getPlayerHead(Player player) {
        SkullMeta clone = this.meta.clone();
        clone.setDisplayName(TextFormatter.format(player, clone.getDisplayName().replace("%player_name%", player.getName())));
        clone.setOwningPlayer((OfflinePlayer)player);
        List lore = clone.getLore();
        if (lore == null) {
            return this.head;
        }
        for (String string : lore) {
            int index = lore.indexOf(string);
            string = TextFormatter.format(player, string);
            PlayerQuests playerQuests = ODailyQuestsAPI.getPlayerQuests(player.getName());
            lore.set(index, TextFormatter.format(string).replace("%achieved%", String.valueOf(playerQuests.getAchievedQuests())).replace("%drawIn%", TimeRemain.timeRemain(player.getName())));
        }
        clone.setLore(lore);
        this.head.setItemMeta((ItemMeta)clone);
        return this.head;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

