/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.interfaces.playerinterface.items.getters;

import com.ordwen.odailyquests.commands.interfaces.playerinterface.items.getters.IInterfaceItem;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.items.getters.ItemGetter;
import com.ordwen.odailyquests.tools.Pair;
import com.ordwen.odailyquests.tools.PluginLogger;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class InterfaceItemGetter
extends ItemGetter
implements IInterfaceItem {
    @Override
    public ItemStack getItem(String material, String itemIndex, String parameter) {
        String[] split = material.split(":", 2);
        return switch (split[0]) {
            case "oraxen" -> this.getOraxenItem(split[1], itemIndex, parameter);
            case "nexo" -> this.getNexoItem(split[1], itemIndex, parameter);
            case "itemsadder" -> this.getItemsAdderItem(split[1], itemIndex, parameter);
            case "mmoitems" -> this.getMMOItemsItem(split[1], itemIndex, parameter);
            case "customhead" -> this.getCustomHead(split[1], itemIndex, parameter);
            case "custommodeldata" -> this.getCustomModelDataItem(split[1], itemIndex, parameter);
            default -> null;
        };
    }

    @Override
    public ItemStack getOraxenItem(String namespace, String itemIndex, String parameter) {
        Pair<String, ItemStack> result = super.getOraxenItem(namespace);
        if (!result.first().isEmpty()) {
            this.configurationError(itemIndex, parameter, result.first());
            return null;
        }
        return result.second();
    }

    @Override
    public ItemStack getNexoItem(String namespace, String itemIndex, String parameter) {
        Pair<String, ItemStack> result = super.getNexoItem(namespace);
        if (!result.first().isEmpty()) {
            this.configurationError(itemIndex, parameter, result.first());
            return null;
        }
        return result.second();
    }

    @Override
    public ItemStack getItemsAdderItem(String namespace, String itemIndex, String parameter) {
        Pair<String, ItemStack> result = super.getItemsAdderItem(namespace);
        if (!result.first().isEmpty()) {
            this.configurationError(itemIndex, parameter, result.first());
            return null;
        }
        return result.second();
    }

    @Override
    public ItemStack getMMOItemsItem(String namespace, String itemIndex, String parameter) {
        Pair<String, ItemStack> result = super.getMMOItemsItem(namespace);
        if (!result.first().isEmpty()) {
            this.configurationError(itemIndex, parameter, result.first());
            return null;
        }
        return result.second();
    }

    @Override
    public ItemStack getCustomHead(String texture, String questIndex, String parameter) {
        Pair<String, ItemStack> result = super.getCustomHead(texture);
        if (!result.first().isEmpty()) {
            this.configurationError(questIndex, parameter, result.first());
            return null;
        }
        return result.second();
    }

    @Override
    public ItemStack getCustomModelDataItem(String customModelData, String questIndex, String parameter) {
        int cmd;
        String[] split = customModelData.split(":");
        if (split.length != 2) {
            this.configurationError(questIndex, parameter, "You need to provide the item and the custom model data.");
            return null;
        }
        Material material = Material.getMaterial((String)split[0].toUpperCase());
        if (material == null) {
            this.configurationError(questIndex, parameter, "The material " + split[0] + " does not exist.");
            return null;
        }
        try {
            cmd = Integer.parseInt(split[1]);
        }
        catch (Exception e) {
            this.configurationError(questIndex, parameter, split[1] + " is not a number!");
            return null;
        }
        Pair<String, ItemStack> result = super.getCustomModelDataItem(material, cmd);
        if (!result.first().isEmpty()) {
            this.configurationError(questIndex, parameter, result.first());
            return null;
        }
        return result.second();
    }

    @Override
    public void configurationError(String itemIndex, String parameter, String reason) {
        PluginLogger.error("-----------------------------------");
        PluginLogger.error("Invalid player interface configuration detected.");
        PluginLogger.error("Item index : " + itemIndex);
        PluginLogger.error("Reason : " + reason);
        if (parameter != null) {
            PluginLogger.error("Parameter : " + parameter);
        }
        PluginLogger.error("-----------------------------------");
    }
}

