/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.player;

import com.ordwen.odailyquests.api.commands.player.PlayerCommandBase;
import com.ordwen.odailyquests.api.commands.player.PlayerCommandRegistry;
import com.ordwen.odailyquests.api.commands.player.PlayerMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerCommands
extends PlayerMessages
implements CommandExecutor {
    private final PlayerCommandRegistry playerCommandRegistry;

    public PlayerCommands(PlayerCommandRegistry playerCommandRegistry) {
        this.playerCommandRegistry = playerCommandRegistry;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            this.playerOnly(sender);
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission(QuestsPermissions.QUESTS_PLAYER_USE.get())) {
            this.noPermission(sender);
            return true;
        }
        if (args.length >= 1) {
            PlayerCommandBase handler = this.playerCommandRegistry.getCommandHandler(args[0]);
            if (handler != null) {
                if (player.hasPermission(handler.getPermission())) {
                    handler.execute(player, args);
                } else {
                    this.noPermission((CommandSender)player);
                }
            } else {
                this.help((CommandSender)player);
            }
        } else {
            PlayerCommandBase handler = this.playerCommandRegistry.getCommandHandler("me");
            handler.execute(player, args);
        }
        return true;
    }
}

