/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.configuration.essentials.Antiglitch;
import com.ordwen.odailyquests.configuration.essentials.CheckForUpdate;
import com.ordwen.odailyquests.configuration.essentials.CustomFurnaceResults;
import com.ordwen.odailyquests.configuration.essentials.CustomTypes;
import com.ordwen.odailyquests.configuration.essentials.Database;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.essentials.JoinMessageDelay;
import com.ordwen.odailyquests.configuration.essentials.Logs;
import com.ordwen.odailyquests.configuration.essentials.PlayerDataLoadDelay;
import com.ordwen.odailyquests.configuration.essentials.Prefix;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.configuration.essentials.RenewInterval;
import com.ordwen.odailyquests.configuration.essentials.RenewTime;
import com.ordwen.odailyquests.configuration.essentials.RerollNotAchieved;
import com.ordwen.odailyquests.configuration.essentials.SafetyMode;
import com.ordwen.odailyquests.configuration.essentials.Synchronization;
import com.ordwen.odailyquests.configuration.essentials.TimestampMode;
import com.ordwen.odailyquests.configuration.functionalities.CommandAliases;
import com.ordwen.odailyquests.configuration.functionalities.CompleteOnlyOnClick;
import com.ordwen.odailyquests.configuration.functionalities.DisabledWorlds;
import com.ordwen.odailyquests.configuration.functionalities.SpawnerProgression;
import com.ordwen.odailyquests.configuration.functionalities.TakeItem;
import com.ordwen.odailyquests.configuration.functionalities.progression.ActionBar;
import com.ordwen.odailyquests.configuration.functionalities.progression.ProgressBar;
import com.ordwen.odailyquests.configuration.functionalities.progression.ProgressionMessage;
import com.ordwen.odailyquests.configuration.functionalities.progression.Title;
import com.ordwen.odailyquests.configuration.functionalities.progression.ToastNotification;
import com.ordwen.odailyquests.configuration.functionalities.rewards.CategoriesRewards;
import com.ordwen.odailyquests.configuration.functionalities.rewards.GlobalReward;
import com.ordwen.odailyquests.configuration.functionalities.rewards.TotalRewards;
import com.ordwen.odailyquests.configuration.integrations.ItemsAdderEnabled;
import com.ordwen.odailyquests.configuration.integrations.NPCNames;
import com.ordwen.odailyquests.configuration.integrations.NexoEnabled;
import com.ordwen.odailyquests.configuration.integrations.OraxenEnabled;
import com.ordwen.odailyquests.configuration.integrations.RoseStackerEnabled;
import com.ordwen.odailyquests.configuration.integrations.SharedMobs;
import com.ordwen.odailyquests.configuration.integrations.WildStackerEnabled;
import com.ordwen.odailyquests.files.FilesManager;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.files.implementations.TotalRewardsFile;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigFactory {
    private static final Map<Class<? extends IConfigurable>, IConfigurable> configs = new LinkedHashMap<Class<? extends IConfigurable>, IConfigurable>();

    private ConfigFactory() {
    }

    public static void registerConfigs(FilesManager filesManager) {
        ConfigurationFile configurationFile = filesManager.getConfigurationFile();
        TotalRewardsFile totalRewardsFile = filesManager.getTotalRewardsFile();
        configs.put(Prefix.class, new Prefix(configurationFile));
        configs.put(Antiglitch.class, new Antiglitch(configurationFile));
        configs.put(CustomFurnaceResults.class, new CustomFurnaceResults(configurationFile));
        configs.put(CustomTypes.class, new CustomTypes(configurationFile));
        configs.put(Database.class, new Database(configurationFile));
        configs.put(PlayerDataLoadDelay.class, new PlayerDataLoadDelay(configurationFile));
        configs.put(Debugger.class, new Debugger(configurationFile));
        configs.put(JoinMessageDelay.class, new JoinMessageDelay(configurationFile));
        configs.put(Logs.class, new Logs(configurationFile));
        configs.put(TimestampMode.class, new TimestampMode(configurationFile));
        configs.put(SafetyMode.class, new SafetyMode(configurationFile));
        configs.put(QuestsPerCategory.class, new QuestsPerCategory(configurationFile));
        configs.put(RerollNotAchieved.class, new RerollNotAchieved(configurationFile));
        configs.put(Synchronization.class, new Synchronization(configurationFile));
        configs.put(RenewInterval.class, new RenewInterval(configurationFile));
        configs.put(RenewTime.class, new RenewTime(configurationFile));
        configs.put(CheckForUpdate.class, new CheckForUpdate(configurationFile));
        configs.put(ActionBar.class, new ActionBar(configurationFile));
        configs.put(ProgressBar.class, new ProgressBar(configurationFile));
        IConfigurable prev = configs.get(ProgressionMessage.class);
        if (prev instanceof ProgressionMessage) {
            ProgressionMessage pm = (ProgressionMessage)prev;
            pm.cleanup();
        }
        configs.put(ProgressionMessage.class, new ProgressionMessage(configurationFile));
        configs.put(Title.class, new Title(configurationFile));
        configs.put(ToastNotification.class, new ToastNotification(configurationFile));
        configs.put(DisabledWorlds.class, new DisabledWorlds(configurationFile));
        configs.put(SpawnerProgression.class, new SpawnerProgression(configurationFile));
        configs.put(TakeItem.class, new TakeItem(configurationFile));
        configs.put(CompleteOnlyOnClick.class, new CompleteOnlyOnClick(configurationFile));
        configs.put(CommandAliases.class, new CommandAliases(configurationFile));
        configs.put(CategoriesRewards.class, new CategoriesRewards(configurationFile));
        configs.put(GlobalReward.class, new GlobalReward(configurationFile));
        configs.put(TotalRewards.class, new TotalRewards(totalRewardsFile));
        configs.put(ItemsAdderEnabled.class, new ItemsAdderEnabled(configurationFile));
        configs.put(NPCNames.class, new NPCNames(configurationFile));
        configs.put(OraxenEnabled.class, new OraxenEnabled(configurationFile));
        configs.put(NexoEnabled.class, new NexoEnabled(configurationFile));
        configs.put(SharedMobs.class, new SharedMobs(configurationFile));
        configs.put(WildStackerEnabled.class, new WildStackerEnabled(configurationFile));
        configs.put(RoseStackerEnabled.class, new RoseStackerEnabled(configurationFile));
        configs.values().forEach(IConfigurable::load);
        if (ODailyQuests.INSTANCE.timerTask != null) {
            ODailyQuests.INSTANCE.timerTask.reload();
        }
    }

    public static <T extends IConfigurable> T getConfig(Class<T> clazz) {
        return (T)((IConfigurable)clazz.cast(configs.get(clazz)));
    }
}

