/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.essentials;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.enums.StorageMode;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import org.bukkit.configuration.ConfigurationSection;

public class Database
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private StorageMode mode;
    private String name;
    private String host;
    private String port;
    private String user;
    private String password;

    public Database(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        String expectedMode = this.configurationFile.getConfig().getString("storage_mode");
        if (expectedMode == null) {
            PluginLogger.error("storage_mode is not defined in the configuration file.");
            throw new IllegalArgumentException("storage_mode is not defined in the configuration file.");
        }
        this.mode = StorageMode.getStorageMode(expectedMode);
        if (this.mode.isLocal()) {
            return;
        }
        ConfigurationSection section = this.configurationFile.getConfig().getConfigurationSection("database");
        if (section == null) {
            PluginLogger.error("Database section is not defined in the configuration file.");
            throw new IllegalArgumentException("Database section is not defined in the configuration file.");
        }
        this.name = section.getString("name");
        this.host = section.getString("host");
        this.user = section.getString("user");
        this.password = section.getString("password");
        this.port = section.getString("port");
    }

    private static Database getInstance() {
        return ConfigFactory.getConfig(Database.class);
    }

    public static StorageMode getMode() {
        return Database.getInstance().mode;
    }

    public static String getName() {
        return Database.getInstance().name;
    }

    public static String getHost() {
        return Database.getInstance().host;
    }

    public static String getUser() {
        return Database.getInstance().user;
    }

    public static String getPassword() {
        return Database.getInstance().password;
    }

    public static String getPort() {
        return Database.getInstance().port;
    }
}

