/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.essentials;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class QuestsPerCategory
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private final Map<String, Integer> questsAmounts = new LinkedHashMap<String, Integer>();
    private int totalQuestsAmount;

    public QuestsPerCategory(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        FileConfiguration config = this.configurationFile.getConfig();
        this.totalQuestsAmount = 0;
        this.questsAmounts.clear();
        ConfigurationSection section = config.getConfigurationSection("quests_per_category");
        if (section == null) {
            PluginLogger.error("No quests_per_category section found! Please check your configuration file.");
            PluginLogger.error("Impossible to load quests. Disabling plugin.");
            Bukkit.getPluginManager().disablePlugin((Plugin)ODailyQuests.INSTANCE);
            return;
        }
        for (String category : section.getKeys(false)) {
            int amount = section.getInt(category);
            if (amount <= 0) {
                PluginLogger.error("Invalid amount of quests for category " + category + ". Please check your configuration file.");
                PluginLogger.error("Impossible to load quests. Disabling plugin.");
                Bukkit.getPluginManager().disablePlugin((Plugin)ODailyQuests.INSTANCE);
                return;
            }
            this.questsAmounts.put(category, amount);
            this.totalQuestsAmount += amount;
        }
    }

    public static int getAmountForCategory(String name) {
        return QuestsPerCategory.getInstance().questsAmounts.getOrDefault(name, -1);
    }

    private static QuestsPerCategory getInstance() {
        return ConfigFactory.getConfig(QuestsPerCategory.class);
    }

    public static int getTotalQuestsAmount() {
        return QuestsPerCategory.getInstance().totalQuestsAmount;
    }

    public static Map<String, Integer> getAllAmounts() {
        return QuestsPerCategory.getInstance().questsAmounts;
    }
}

