/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.essentials;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class RenewInterval
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private Duration interval;
    private String days;
    private String hours;
    private String minutes;
    private String fewSeconds;

    public RenewInterval(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        FileConfiguration config = this.configurationFile.getConfig();
        String intervalStr = config.getString("renew_interval", "1d");
        this.interval = this.parseDuration(intervalStr);
        ConfigurationSection initials = config.getConfigurationSection("temporality_initials");
        if (initials == null) {
            PluginLogger.error("Temporality initials are not set in the configuration file.");
            PluginLogger.error("Default values will be used.");
            this.days = "d";
            this.hours = "h";
            this.minutes = "m";
            this.fewSeconds = "few seconds";
            return;
        }
        this.days = initials.getString("days");
        this.hours = initials.getString("hours");
        this.minutes = initials.getString("minutes");
        this.fewSeconds = initials.getString("few_seconds");
    }

    private Duration parseDuration(String interval) {
        Pattern pattern = Pattern.compile("(\\d+)([dhm])");
        Matcher matcher = pattern.matcher(interval);
        Duration duration = Duration.ZERO;
        while (matcher.find()) {
            String unit;
            int value = Integer.parseInt(matcher.group(1));
            duration = switch (unit = matcher.group(2)) {
                case "d" -> duration.plus((long)value, ChronoUnit.DAYS);
                case "h" -> duration.plus((long)value, ChronoUnit.HOURS);
                case "m" -> duration.plus((long)value, ChronoUnit.MINUTES);
                default -> duration;
            };
        }
        return duration;
    }

    private static RenewInterval getInstance() {
        return ConfigFactory.getConfig(RenewInterval.class);
    }

    public static String getDayInitial() {
        return RenewInterval.getInstance().days;
    }

    public static String getHourInitial() {
        return RenewInterval.getInstance().hours;
    }

    public static String getMinuteInitial() {
        return RenewInterval.getInstance().minutes;
    }

    public static String getFewSeconds() {
        return RenewInterval.getInstance().fewSeconds;
    }

    public static Duration getRenewInterval() {
        return RenewInterval.getInstance().interval;
    }
}

