/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.lang.reflect.Field;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.ConfigurationSection;

public class CommandAliases
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private boolean isKeepingOnlyAliases = false;

    public CommandAliases(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        List aliases = this.configurationFile.getConfig().getStringList("command_aliases");
        for (String alias : aliases) {
            this.registerAlias(alias);
        }
        this.isKeepingOnlyAliases = this.configurationFile.getConfig().getBoolean("keep_only_aliases_in_completion", false);
    }

    private void registerAlias(String alias) {
        ODailyQuests plugin = ODailyQuests.INSTANCE;
        PluginCommand command = plugin.getCommand("dquests");
        try {
            Field bukkitCommandMap = plugin.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(plugin.getServer());
            commandMap.register(alias, "odailyquests", (Command)command);
        }
        catch (Exception e) {
            PluginLogger.error("Failed to register command alias '" + alias + "' for command 'dquests' : " + e.getMessage());
        }
    }

    private List<String> getSubcommandAliasesInternal(String subcommandName) {
        ConfigurationSection section = this.configurationFile.getConfig().getConfigurationSection("subcommand_aliases");
        if (section == null) {
            return List.of();
        }
        return section.getStringList(subcommandName.toLowerCase());
    }

    private boolean isKeepingOnlyAliasesInternal() {
        return this.isKeepingOnlyAliases;
    }

    private static CommandAliases getInstance() {
        return ConfigFactory.getConfig(CommandAliases.class);
    }

    public static List<String> getSubcommandAliases(String subcommandName) {
        return CommandAliases.getInstance().getSubcommandAliasesInternal(subcommandName);
    }

    public static boolean isKeepingOnlyAliases() {
        return CommandAliases.getInstance().isKeepingOnlyAliasesInternal();
    }
}

