/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import java.util.HashSet;
import java.util.Set;

public class DisabledWorlds
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private Set<String> disabledWorldNames;

    public DisabledWorlds(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        this.disabledWorldNames = new HashSet<String>();
        this.disabledWorldNames.addAll(this.configurationFile.getConfig().getStringList("disabled_worlds"));
    }

    public boolean isWorldDisabledInternal(String world) {
        boolean isDisabled = false;
        for (String disabledWorld : this.disabledWorldNames) {
            if (disabledWorld.startsWith("?")) {
                worldLabel = disabledWorld.substring(1);
                isDisabled = world.endsWith(worldLabel);
            } else if (disabledWorld.endsWith("?")) {
                worldLabel = disabledWorld.substring(0, disabledWorld.length() - 1);
                isDisabled = world.startsWith(worldLabel);
            } else {
                isDisabled = world.equals(disabledWorld);
            }
            if (!isDisabled) continue;
            break;
        }
        return isDisabled;
    }

    private static DisabledWorlds getInstance() {
        return ConfigFactory.getConfig(DisabledWorlds.class);
    }

    public static boolean isWorldDisabled(String world) {
        return DisabledWorlds.getInstance().isWorldDisabledInternal(world);
    }
}

