/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities.progression;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class ProgressBar
implements IConfigurable {
    private String symbol;
    private String completedColor;
    private String remainingColor;
    private int amountOfSymbols;
    private final ConfigurationFile configurationFile;

    public ProgressBar(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        ConfigurationSection section = this.configurationFile.getConfig().getConfigurationSection("progress_bar");
        if (section == null) {
            PluginLogger.warn("Progress bar section is missing in the configuration file.");
            PluginLogger.warn("Using default progress bar.");
            this.symbol = "|";
            this.completedColor = ChatColor.GREEN.toString();
            this.remainingColor = ChatColor.GRAY.toString();
            this.amountOfSymbols = 20;
            return;
        }
        this.symbol = section.getString("symbol", "|");
        this.completedColor = TextFormatter.format(section.getString("completed_color", ChatColor.GREEN.toString()));
        this.remainingColor = TextFormatter.format(section.getString("remaining_color", ChatColor.GRAY.toString()));
        this.amountOfSymbols = section.getInt("amount_of_symbols", 20);
    }

    public String getProgressBarInternal(int amount, int required) {
        int i;
        StringBuilder builder = new StringBuilder();
        int amountOfCompleted = amount * this.amountOfSymbols / required;
        int amountOfRemaining = this.amountOfSymbols - amountOfCompleted;
        for (i = 0; i < amountOfCompleted; ++i) {
            builder.append(this.completedColor).append(this.symbol);
        }
        for (i = 0; i < amountOfRemaining; ++i) {
            builder.append(this.remainingColor).append(this.symbol);
        }
        return builder.toString();
    }

    private static ProgressBar getInstance() {
        return ConfigFactory.getConfig(ProgressBar.class);
    }

    public static String getProgressBar(int amount, int required) {
        return ProgressBar.getInstance().getProgressBarInternal(amount, required);
    }
}

