/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities.progression;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.configuration.functionalities.progression.ProgressBar;
import com.ordwen.odailyquests.enums.ProgressionMessageType;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ProgressionMessage
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private boolean isEnabled;
    private String message;
    private ProgressionMessageType progressionMessageType;
    private BarColor barColor;
    private BarStyle barStyle;
    private final Map<Player, BossBar> currentBossBars = new HashMap<Player, BossBar>();

    public ProgressionMessage(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        String type;
        this.isEnabled = this.configurationFile.getConfig().getBoolean("progression_message.enabled");
        if (!this.isEnabled) {
            return;
        }
        this.message = this.configurationFile.getConfig().getString("progression_message.text");
        if (this.message == null) {
            PluginLogger.error("Progression message is null, disabling progression message.");
            PluginLogger.error("Please set a valid message in the configuration file (progression_message.text).");
            this.isEnabled = false;
        }
        if ((type = this.configurationFile.getConfig().getString("progression_message.type")) == null) {
            PluginLogger.warn("Progression message type is null, defaulting to CHAT.");
            this.progressionMessageType = ProgressionMessageType.CHAT;
            return;
        }
        try {
            this.progressionMessageType = ProgressionMessageType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            PluginLogger.warn("Progression message type is invalid, defaulting to CHAT.");
            this.progressionMessageType = ProgressionMessageType.CHAT;
        }
        if (this.progressionMessageType == ProgressionMessageType.BOSSBAR) {
            this.loadBossBar();
        }
    }

    private void loadBossBar() {
        String color = this.configurationFile.getConfig().getString("progression_message.bossbar.color");
        String style = this.configurationFile.getConfig().getString("progression_message.bossbar.style");
        if (color == null) {
            PluginLogger.warn("Progression message bossbar color is null, defaulting to BLUE.");
            this.barColor = BarColor.BLUE;
        } else {
            try {
                this.barColor = BarColor.valueOf((String)color.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                PluginLogger.warn("Progression message bossbar color is invalid, defaulting to BLUE.");
                this.barColor = BarColor.BLUE;
            }
        }
        if (style == null) {
            PluginLogger.warn("Progression message bossbar style is null, defaulting to SOLID.");
            this.barStyle = BarStyle.SOLID;
        } else {
            try {
                this.barStyle = BarStyle.valueOf((String)style.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                PluginLogger.warn("Progression message bossbar style is invalid, defaulting to SOLID.");
                this.barStyle = BarStyle.SOLID;
            }
        }
    }

    public void sendProgressionMessageInternal(Player player, String questName, int progression, int required) {
        if (this.isEnabled) {
            String parsedQuestName = TextFormatter.format(player, questName);
            String toSend = TextFormatter.format(player, this.message.replace("%player%", player.getDisplayName()).replace("%questName%", parsedQuestName).replace("%progress%", String.valueOf(progression)).replace("%required%", String.valueOf(required)).replace("%progressBar%", ProgressBar.getProgressBar(progression, required)));
            switch (this.progressionMessageType) {
                case ACTIONBAR: {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)toSend));
                    break;
                }
                case CHAT: {
                    player.sendMessage(toSend);
                    break;
                }
                case BOSSBAR: {
                    this.currentBossBars.computeIfAbsent(player, p -> {
                        BossBar bossBar = Bukkit.getServer().createBossBar(toSend, this.barColor, this.barStyle, new BarFlag[0]);
                        bossBar.addPlayer(p);
                        ProgressionMessage self = this;
                        ODailyQuests.morePaperLib.scheduling().entitySpecificScheduler((Entity)p).runDelayed(() -> self.removeBossBarInternal((Player)p), null, 100L);
                        return bossBar;
                    }).setTitle(toSend);
                }
            }
        }
    }

    private void removeBossBarInternal(Player player) {
        if (this.currentBossBars.containsKey(player)) {
            this.currentBossBars.get(player).removePlayer(player);
            this.currentBossBars.remove(player);
        }
    }

    public void cleanup() {
        this.currentBossBars.forEach((p, bar) -> bar.removePlayer(p));
        this.currentBossBars.clear();
    }

    private static ProgressionMessage getInstance() {
        return ConfigFactory.getConfig(ProgressionMessage.class);
    }

    public static void sendProgressionMessage(Player player, String questName, int progression, int required) {
        ProgressionMessage.getInstance().sendProgressionMessageInternal(player, questName, progression, required);
    }

    public static void removeBossBar(Player player) {
        ProgressionMessage.getInstance().removeBossBarInternal(player);
    }
}

