/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities.progression;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class Title
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private boolean isEnabled;
    private int fadeIn;
    private int fadeOut;
    private int stay;
    private String mainTitle;
    private String subTitle;

    public Title(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        ConfigurationSection section = this.configurationFile.getConfig().getConfigurationSection("title");
        if (section == null) {
            PluginLogger.error("Title section is missing in the configuration file. Disabling.");
            this.isEnabled = false;
            return;
        }
        this.isEnabled = section.getBoolean("enabled");
        if (this.isEnabled) {
            this.fadeIn = section.getInt("fadeIn");
            this.stay = section.getInt("stay");
            this.fadeOut = section.getInt("fadeOut");
            this.mainTitle = TextFormatter.format(section.getString("text"));
            this.subTitle = TextFormatter.format(section.getString("subtitle"));
            PluginLogger.fine("Title successfully loaded.");
        } else {
            PluginLogger.fine("Title is disabled.");
        }
    }

    public void sendTitleInternal(Player player, String questName) {
        if (this.isEnabled) {
            String parsedQuestName = TextFormatter.format(player, questName);
            String playerMainTitle = TextFormatter.format(player, this.mainTitle.replace("%player%", player.getDisplayName()).replace("%questName%", parsedQuestName));
            String playerSubTitle = TextFormatter.format(player, this.subTitle.replace("%player%", player.getDisplayName()).replace("%questName%", parsedQuestName));
            player.sendTitle(playerMainTitle, playerSubTitle, this.fadeIn, this.stay, this.fadeOut);
        }
    }

    private static Title getInstance() {
        return ConfigFactory.getConfig(Title.class);
    }

    public static void sendTitle(Player player, String questName) {
        Title.getInstance().sendTitleInternal(player, questName);
    }
}

