/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities.rewards;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.rewards.Reward;
import com.ordwen.odailyquests.rewards.RewardLoader;
import com.ordwen.odailyquests.rewards.RewardManager;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class CategoriesRewards
implements IConfigurable {
    private final Map<String, Reward> categoryRewards = new HashMap<String, Reward>();
    private final ConfigurationFile configurationFile;
    private final RewardLoader rewardLoader = new RewardLoader();

    public CategoriesRewards(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        ConfigurationSection categoriesRewardsConfig = this.configurationFile.getConfig().getConfigurationSection("categories_rewards");
        if (categoriesRewardsConfig == null) {
            PluginLogger.error("categories_rewards section is missing in the configuration file.");
            return;
        }
        for (String category : categoriesRewardsConfig.getKeys(false)) {
            ConfigurationSection rewardSection = categoriesRewardsConfig.getConfigurationSection(category);
            if (rewardSection == null) {
                PluginLogger.error("Reward section for category " + category + " is missing in the configuration file.");
                continue;
            }
            Reward reward = this.rewardLoader.getRewardFromSection(rewardSection, "config.yml", null);
            this.categoryRewards.put(category, reward);
        }
    }

    public void sendCategoryRewardInternal(Player player, String category) {
        if (!this.categoryRewards.containsKey(category)) {
            Debugger.write("Category " + category + " is missing in the categories_rewards section.");
            return;
        }
        Reward reward = this.categoryRewards.get(category);
        if (reward != null) {
            String msg = QuestsMessages.CATEGORY_QUESTS_ACHIEVED.toString();
            if (msg != null) {
                player.sendMessage(msg.replace("%category%", category));
            }
            RewardManager.sendReward(player, reward, Collections.emptyMap());
        } else {
            PluginLogger.error("No reward found for category " + category);
        }
    }

    private static CategoriesRewards getInstance() {
        return ConfigFactory.getConfig(CategoriesRewards.class);
    }

    public static void sendCategoryReward(Player player, String category) {
        CategoriesRewards.getInstance().sendCategoryRewardInternal(player, category);
    }
}

