/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities.rewards;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.rewards.Reward;
import com.ordwen.odailyquests.rewards.RewardLoader;
import com.ordwen.odailyquests.rewards.RewardManager;
import com.ordwen.odailyquests.rewards.RewardType;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class GlobalReward
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private final RewardLoader rewardLoader = new RewardLoader();
    private boolean isEnabled;
    private Reward reward;

    public GlobalReward(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        ConfigurationSection globalRewardSection = this.configurationFile.getConfig().getConfigurationSection("global_reward");
        if (globalRewardSection == null || !globalRewardSection.contains("enabled")) {
            PluginLogger.error("Global reward section is missing or incomplete in the configuration file. Disabling.");
            this.isEnabled = false;
            return;
        }
        this.isEnabled = globalRewardSection.getBoolean("enabled");
        if (this.isEnabled) {
            RewardType rewardType = RewardType.valueOf(globalRewardSection.getString(".reward_type"));
            String message = TextFormatter.format(globalRewardSection.getString(".message"));
            this.reward = rewardType == RewardType.COMMAND ? new Reward(rewardType, globalRewardSection.getStringList(".commands"), message) : new Reward(rewardType, globalRewardSection.getInt(".amount"), message);
            this.reward = this.rewardLoader.getRewardFromSection(globalRewardSection, "config.yml", null);
            PluginLogger.fine("Global reward successfully loaded.");
        } else {
            PluginLogger.fine("Global reward is disabled.");
        }
    }

    public void sendGlobalRewardInternal(String playerName) {
        if (this.isEnabled) {
            Player player = Bukkit.getPlayer((String)playerName);
            if (player == null) {
                PluginLogger.warn("Impossible to send global reward to " + playerName + " because he is offline.");
                return;
            }
            String msg = QuestsMessages.ALL_QUESTS_ACHIEVED.getMessage(playerName);
            if (msg != null) {
                player.sendMessage(msg);
            }
            RewardManager.sendReward(Bukkit.getPlayer((String)playerName), this.reward, Collections.emptyMap());
        }
    }

    private static GlobalReward getInstance() {
        return ConfigFactory.getConfig(GlobalReward.class);
    }

    public static void sendGlobalReward(String playerName) {
        GlobalReward.getInstance().sendGlobalRewardInternal(playerName);
    }
}

