/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities.rewards;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.TotalRewardsFile;
import com.ordwen.odailyquests.rewards.Reward;
import com.ordwen.odailyquests.rewards.RewardLoader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class TotalRewards
implements IConfigurable {
    private final FileConfiguration config;
    private final RewardLoader rewardLoader;
    private final Map<Integer, Reward> globalTotalRewards;
    private final Map<String, Map<Integer, Reward>> categoryTotalRewards;
    private boolean enabled;

    public TotalRewards(TotalRewardsFile totalRewardsFile) {
        this.config = totalRewardsFile.getConfig();
        this.rewardLoader = new RewardLoader();
        this.globalTotalRewards = new HashMap<Integer, Reward>();
        this.categoryTotalRewards = new HashMap<String, Map<Integer, Reward>>();
    }

    @Override
    public void load() {
        this.enabled = this.config.getBoolean("enabled", false);
        if (this.enabled) {
            this.loadGlobalTotalRewards(this.config);
            this.loadCategoryTotalRewards(this.config);
        }
    }

    private void loadGlobalTotalRewards(FileConfiguration config) {
        ConfigurationSection globalSection = config.getConfigurationSection("global_total_rewards");
        if (globalSection != null) {
            for (String key : globalSection.getKeys(false)) {
                int questCount = Integer.parseInt(key);
                ConfigurationSection rewardSection = globalSection.getConfigurationSection(key);
                Reward reward = this.rewardLoader.getRewardFromSection(rewardSection, "totalRewards.yml", key);
                this.globalTotalRewards.put(questCount, reward);
            }
        }
    }

    private void loadCategoryTotalRewards(FileConfiguration config) {
        ConfigurationSection categorySection = config.getConfigurationSection("category_total_rewards");
        if (categorySection != null) {
            for (String category : categorySection.getKeys(false)) {
                ConfigurationSection categoryRewardsSection = categorySection.getConfigurationSection(category);
                HashMap<Integer, Reward> categoryRewards = new HashMap<Integer, Reward>();
                for (String key : categoryRewardsSection.getKeys(false)) {
                    int questCount = Integer.parseInt(key);
                    ConfigurationSection rewardSection = categoryRewardsSection.getConfigurationSection(key);
                    Reward reward = this.rewardLoader.getRewardFromSection(rewardSection, "totalRewards.yml", key);
                    categoryRewards.put(questCount, reward);
                }
                this.categoryTotalRewards.put(category, categoryRewards);
            }
        }
    }

    private Reward getGlobalTotalRewardInternal(int questCount) {
        if (!this.enabled) {
            return null;
        }
        return this.globalTotalRewards.get(questCount);
    }

    private Reward getCategoryTotalRewardInternal(String category, int questCount) {
        if (!this.enabled || category == null || category.isEmpty()) {
            return null;
        }
        Map<Integer, Reward> categoryRewards = this.categoryTotalRewards.get(category);
        if (categoryRewards != null) {
            return categoryRewards.get(questCount);
        }
        return null;
    }

    private boolean isGlobalStepInternal(int questCount) {
        return this.globalTotalRewards.containsKey(questCount);
    }

    private boolean isCategoryStepInternal(String category, int questCount) {
        if (category == null || category.isEmpty()) {
            return false;
        }
        Map<Integer, Reward> categoryRewards = this.categoryTotalRewards.get(category);
        return categoryRewards != null && categoryRewards.containsKey(questCount);
    }

    private static TotalRewards getInstance() {
        return ConfigFactory.getConfig(TotalRewards.class);
    }

    public static Reward getGlobalTotalReward(int questCount) {
        return TotalRewards.getInstance().getGlobalTotalRewardInternal(questCount);
    }

    public static Reward getCategoryTotalReward(String category, int questCount) {
        return TotalRewards.getInstance().getCategoryTotalRewardInternal(category, questCount);
    }

    public static boolean isGlobalStep(int questCount) {
        return TotalRewards.getInstance().isGlobalStepInternal(questCount);
    }

    public static boolean isCategoryStep(String category, int questCount) {
        return TotalRewards.getInstance().isCategoryStepInternal(category, questCount);
    }
}

