/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.inventory;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.PlayerQuestsInterface;
import com.ordwen.odailyquests.configuration.essentials.CustomFurnaceResults;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.events.customs.CustomFurnaceExtractEvent;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.clickable.ClickableChecker;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestContext;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.plugin.Plugin;

public class InventoryClickListener
extends ClickableChecker
implements Listener {
    private final PlayerQuestsInterface playerQuestsInterface;

    public InventoryClickListener(PlayerQuestsInterface playerQuestsInterface) {
        this.playerQuestsInterface = playerQuestsInterface;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        ItemStack clickedItem;
        if (event.getClickedInventory() == null) {
            return;
        }
        InventoryAction action = event.getAction();
        if (action == InventoryAction.NOTHING) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!QuestsManager.getActiveQuests().containsKey(player.getName())) {
            return;
        }
        boolean isPlayerInterface = false;
        String inventoryName = event.getView().getTitle();
        if (inventoryName.startsWith(this.playerQuestsInterface.getInterfaceName(player))) {
            isPlayerInterface = true;
            event.setCancelled(true);
        }
        if ((clickedItem = event.getCurrentItem()) == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (this.handleCustomFurnaceResult(event, action, clickedItem, player)) {
            return;
        }
        QuestContext.Builder contextBuilder = new QuestContext.Builder(player).clickedItem(clickedItem);
        if (this.handleVillagerTrading(event, contextBuilder)) {
            return;
        }
        if (isPlayerInterface) {
            if (this.handlePlayerInterfaceClick(event, clickedItem, player)) {
                return;
            }
            this.processQuestCompletion(contextBuilder.build());
        }
    }

    private boolean handlePlayerInterfaceClick(InventoryClickEvent event, ItemStack clickedItem, Player player) {
        if (event.getAction() == InventoryAction.HOTBAR_SWAP) {
            return true;
        }
        if (this.playerQuestsInterface.isFillItem(clickedItem)) {
            return true;
        }
        int slot = event.getRawSlot();
        if (this.handlePlayerCommandItem(player, slot)) {
            return true;
        }
        if (this.handleConsoleCommandItem(player, slot)) {
            return true;
        }
        return this.handleCloseItem(clickedItem, player);
    }

    private boolean handleVillagerTrading(InventoryClickEvent event, QuestContext.Builder contextBuilder) {
        if (!this.isVillagerResultSlot(event)) {
            return false;
        }
        Debugger.write("Detected villager trade action");
        MerchantInventory merchantInventory = (MerchantInventory)event.getClickedInventory();
        if (merchantInventory == null) {
            Debugger.write("Merchant Inventory is null");
            return true;
        }
        InventoryHolder inventoryHolder = event.getClickedInventory().getHolder();
        if (inventoryHolder instanceof Villager) {
            Villager villager = (Villager)inventoryHolder;
            this.processVillagerTrade(event, merchantInventory, villager, contextBuilder);
        }
        return true;
    }

    private boolean isVillagerResultSlot(InventoryClickEvent event) {
        return event.getInventory().getType() == InventoryType.MERCHANT && event.getSlotType() == InventoryType.SlotType.RESULT;
    }

    private void processVillagerTrade(InventoryClickEvent event, MerchantInventory merchantInventory, Villager villager, QuestContext.Builder contextBuilder) {
        Merchant merchant = merchantInventory.getMerchant();
        MerchantRecipe selectedRecipe = merchantInventory.getSelectedRecipe();
        if (selectedRecipe == null) {
            Debugger.write("Merchant or selected recipe is null");
            return;
        }
        int perTradeResult = Math.max(1, selectedRecipe.getResult().getAmount());
        int idx = this.findRecipeIndex(merchant, selectedRecipe);
        if (idx < 0) {
            Debugger.write("Cannot find selected recipe index in merchant list; fallback per click.");
            contextBuilder.villagerTrade(villager, selectedRecipe, perTradeResult);
            this.processQuestCompletion(contextBuilder.build());
            return;
        }
        int beforeUses = merchant.getRecipe(idx).getUses();
        Debugger.write("[TradeDelta] Before uses=" + beforeUses + ", perTradeResult=" + perTradeResult + ", click=" + String.valueOf(event.getClick()) + ", action=" + String.valueOf(event.getAction()));
        this.scheduleDeltaProgress(merchant, idx, beforeUses, perTradeResult, villager, selectedRecipe, contextBuilder);
    }

    private void scheduleDeltaProgress(Merchant merchant, int idx, int beforeUses, int perTradeResult, Villager villager, MerchantRecipe selectedRecipe, QuestContext.Builder contextBuilder) {
        Bukkit.getScheduler().runTask((Plugin)ODailyQuests.INSTANCE, () -> {
            try {
                MerchantRecipe afterRec = merchant.getRecipe(idx);
                int afterUses = afterRec.getUses();
                int deltaTrades = Math.max(0, afterUses - beforeUses);
                Debugger.write("[TradeDelta] After uses=" + afterUses + " -> deltaTrades=" + deltaTrades);
                if (deltaTrades == 0) {
                    Debugger.write("[TradeDelta] No trades executed (delta=0). No quest progress.");
                    return;
                }
                int amount = deltaTrades * perTradeResult;
                Debugger.write("[TradeDelta] Final quest amount=" + amount + " (deltaTrades=" + deltaTrades + " * perTradeResult=" + perTradeResult + ")");
                contextBuilder.villagerTrade(villager, selectedRecipe, amount);
                this.processQuestCompletion(contextBuilder.build());
            }
            catch (Exception e) {
                Debugger.write("[TradeDelta] ERROR while reading after-uses: " + e.getMessage());
                contextBuilder.villagerTrade(villager, selectedRecipe, perTradeResult);
                this.processQuestCompletion(contextBuilder.build());
            }
        });
    }

    private boolean handleCustomFurnaceResult(InventoryClickEvent event, InventoryAction action, ItemStack clickedItem, Player player) {
        if (!CustomFurnaceResults.isEnabled()) {
            return false;
        }
        InventoryType inventoryType = event.getInventory().getType();
        if (inventoryType != InventoryType.FURNACE && inventoryType != InventoryType.BLAST_FURNACE && inventoryType != InventoryType.SMOKER) {
            return false;
        }
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return true;
        }
        int amount = switch (action) {
            case InventoryAction.PICKUP_HALF -> (int)Math.ceil((double)clickedItem.getAmount() / 2.0);
            case InventoryAction.PICKUP_ONE, InventoryAction.DROP_ONE_SLOT -> 1;
            case InventoryAction.MOVE_TO_OTHER_INVENTORY -> {
                int max = clickedItem.getAmount();
                yield Math.min(max, this.fits(clickedItem, player.getInventory().getStorageContents()));
            }
            default -> clickedItem.getAmount();
        };
        if (amount == 0) {
            return true;
        }
        CustomFurnaceExtractEvent customFurnaceExtractEvent = new CustomFurnaceExtractEvent(player, clickedItem, amount);
        Bukkit.getServer().getPluginManager().callEvent((Event)customFurnaceExtractEvent);
        return true;
    }

    private int findRecipeIndex(Merchant merchant, MerchantRecipe target) {
        List list = merchant.getRecipes();
        for (int i = 0; i < list.size(); ++i) {
            MerchantRecipe r = (MerchantRecipe)list.get(i);
            if (!this.sameRecipe(r, target)) continue;
            return i;
        }
        return -1;
    }

    private boolean sameRecipe(MerchantRecipe a, MerchantRecipe b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (this.areDifferentItems(a.getResult(), b.getResult())) {
            return false;
        }
        List ia = a.getIngredients();
        List ib = b.getIngredients();
        if (ia.size() != ib.size()) {
            return false;
        }
        for (int i = 0; i < ia.size(); ++i) {
            if (!this.areDifferentItems((ItemStack)ia.get(i), (ItemStack)ib.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean areDifferentItems(ItemStack x, ItemStack y) {
        return !this.areSameItem(x, y);
    }

    private boolean areSameItem(ItemStack x, ItemStack y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        try {
            return x.isSimilar(y) && x.getAmount() == y.getAmount();
        }
        catch (Exception e) {
            Debugger.write("[areSameItem] ERROR while checking item equality: " + String.valueOf(e));
            return false;
        }
    }

    private boolean handleCloseItem(ItemStack clickedItem, Player player) {
        if (this.playerQuestsInterface.isCloseItem(clickedItem)) {
            player.closeInventory();
            return true;
        }
        return false;
    }

    private boolean handlePlayerCommandItem(Player player, int slot) {
        if (this.playerQuestsInterface.isPlayerCommandItem(slot)) {
            for (String cmd : this.playerQuestsInterface.getPlayerCommands(slot)) {
                Bukkit.getServer().dispatchCommand((CommandSender)player, cmd);
            }
            return true;
        }
        return false;
    }

    private boolean handleConsoleCommandItem(Player player, int slot) {
        if (this.playerQuestsInterface.isConsoleCommandItem(slot)) {
            for (String cmd : this.playerQuestsInterface.getConsoleCommands(slot)) {
                ODailyQuests.morePaperLib.scheduling().globalRegionalScheduler().run(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd.replace("%player%", player.getName())));
            }
            return true;
        }
        return false;
    }
}

